/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.ui;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableResizeHelper {
    private final TableViewer tableViewer;

    public TableResizeHelper(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public void enableResizing() {
        ControlListener resizeListener = new ControlListener(){

            public void controlResized(ControlEvent e) {
                TableResizeHelper.this.resizeTable();
            }

            public void controlMoved(ControlEvent e) {
            }
        };
        this.tableViewer.getTable().addControlListener(resizeListener);
        TableColumn[] cols = this.tableViewer.getTable().getColumns();
        if (cols != null) {
            int i = 0;
            while (i < cols.length - 1) {
                cols[i].addControlListener(resizeListener);
                ++i;
            }
        }
        this.resizeTable();
    }

    protected void resizeTable() {
        Table tableComposite = this.tableViewer.getTable();
        Rectangle tableCompositeArea = tableComposite.getClientArea();
        int width = tableCompositeArea.width;
        this.resizeTableColumns(width, this.tableViewer.getTable());
    }

    protected void resizeTableColumns(int tableWidth, Table table) {
        TableColumn[] tableColumns = table.getColumns();
        if (tableColumns.length == 0) {
            return;
        }
        int total = 0;
        TableColumn[] tableColumnArray = tableColumns;
        int n = tableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            total += column.getWidth();
            ++n2;
        }
        TableColumn lastColumn = tableColumns[tableColumns.length - 1];
        int newWidth = tableWidth - total + lastColumn.getWidth();
        if (newWidth > 0) {
            lastColumn.setWidth(newWidth);
        }
    }
}

