/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.ssl;

import com.atlassian.theplugin.commons.configuration.GeneralConfigurationBean;
import com.atlassian.theplugin.commons.remoteapi.rest.AbstractHttpSession;
import com.atlassian.theplugin.commons.ssl.CertMessageDialog;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorTrustManager
implements X509TrustManager {
    private static final Collection<String> ALREADY_REJECTED_CERTS = new HashSet<String>();
    private static Collection<String> temporarilyAcceptedCerts = Collections.synchronizedCollection(new HashSet());
    private final GeneralConfigurationBean configuration;
    private CertMessageDialog certMessageDialog;
    private X509TrustManager standardTrustManager;
    private static ThreadLocal<String> url = new ThreadLocal();

    public static String getUrl() {
        return url.get();
    }

    public ConnectorTrustManager(GeneralConfigurationBean configuration, CertMessageDialog certMessageDialog, KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManager[] trustmanagers;
        this.configuration = configuration;
        this.certMessageDialog = certMessageDialog;
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keyStore);
        TrustManager[] trustManagerArray = trustmanagers = factory.getTrustManagers();
        int n = trustmanagers.length;
        int n2 = 0;
        while (n2 < n) {
            TrustManager trustmanager = trustManagerArray[n2];
            if (trustmanager instanceof X509TrustManager) {
                this.standardTrustManager = (X509TrustManager)trustmanager;
                return;
            }
            ++n2;
        }
        if (this.standardTrustManager == null) {
            throw new NoSuchAlgorithmException("cannot retrieve default trust manager found");
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(chain, authType);
    }

    private boolean isSelfSigned(X509Certificate certificate) {
        return certificate.getSubjectDN().equals(certificate.getIssuerDN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkServerTrusted(final X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.standardTrustManager.checkServerTrusted(chain, authType);
            return;
        }
        catch (CertificateException e) {
            Class<ConnectorTrustManager> clazz = ConnectorTrustManager.class;
            synchronized (ConnectorTrustManager.class) {
                String strCert = chain[0].toString();
                if (ALREADY_REJECTED_CERTS.contains(strCert)) {
                    throw e;
                }
                if (this.checkChain(chain, this.configuration.getCerts()) || this.checkChain(chain, temporarilyAcceptedCerts)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                String message = e.getMessage();
                message = message.substring(message.lastIndexOf(":") + 1);
                if (this.isSelfSigned(chain[0])) {
                    message = "Self-signed certificate";
                }
                try {
                    chain[0].checkValidity();
                }
                catch (CertificateExpiredException certificateExpiredException) {
                    message = "Certificate expired";
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    message = "Certificate not yet valid";
                }
                final String server = AbstractHttpSession.getUrl().getHost();
                final int[] accepted = new int[1];
                try {
                    final String message1 = message;
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            if (ConnectorTrustManager.this.certMessageDialog != null) {
                                ConnectorTrustManager.this.certMessageDialog.show(server, message1, chain);
                                if (ConnectorTrustManager.this.certMessageDialog.isOK()) {
                                    if (ConnectorTrustManager.this.certMessageDialog.isTemporarily()) {
                                        accepted[0] = 1;
                                        return;
                                    }
                                    accepted[0] = 2;
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
                switch (accepted[0]) {
                    case 1: {
                        temporarilyAcceptedCerts.add(strCert);
                        break;
                    }
                    case 2: {
                        Object object = this.configuration;
                        synchronized (object) {
                            this.configuration.addCert(strCert);
                            break;
                        }
                    }
                    default: {
                        Object object = ALREADY_REJECTED_CERTS;
                        synchronized (object) {
                            ALREADY_REJECTED_CERTS.add(strCert);
                            throw e;
                        }
                    }
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }
    }

    private boolean checkChain(X509Certificate[] chain, Collection<String> certs) {
        X509Certificate[] x509CertificateArray = chain;
        int n = chain.length;
        int n2 = 0;
        while (n2 < n) {
            X509Certificate cert = x509CertificateArray[n2];
            if (certs.contains(cert.toString())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

