/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.core.model.ILazyInitializedModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.ui.navigator.actions.ILinkHelperExtension;
import org.springsource.ide.eclipse.commons.ui.SpringUIUtils;

public class BeansNavigatorLinkHelper
implements ILinkHelper,
ILinkHelperExtension {
    public void activateEditor(IWorkbenchPage page, IStructuredSelection selection) {
    }

    public IStructuredSelection findSelection(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            ISelection selection;
            IModelElement element;
            IEditorPart editor;
            IFile file = ((IFileEditorInput)input).getFile();
            IBeansProject project = BeansCorePlugin.getModel().getProject(file.getProject());
            if (project instanceof ILazyInitializedModelElement && !((ILazyInitializedModelElement)project).isInitialized()) {
                return StructuredSelection.EMPTY;
            }
            IBeansConfig config = BeansCorePlugin.getModel().getConfig(file);
            if (config != null && (editor = SpringUIUtils.getActiveEditor()).getEditorInput() == input && editor.getSite() != null && editor.getSite().getSelectionProvider() != null && (element = BeansUIUtils.getSelectedElement(selection = editor.getSite().getSelectionProvider().getSelection(), (IModelElement)config)) != null) {
                return new TreeSelection(BeansUIUtils.createTreePath(element));
            }
        }
        return StructuredSelection.EMPTY;
    }

    public IStructuredSelection findSelection(Object object) {
        if (object instanceof ElementImpl) {
            int endLine;
            ElementImpl element = (ElementImpl)object;
            IStructuredDocument document = element.getStructuredDocument();
            IFile resource = SpringUIUtils.getFile((IStructuredDocument)document);
            IBeansProject project = BeansCorePlugin.getModel().getProject(resource.getProject());
            if (project instanceof ILazyInitializedModelElement && !((ILazyInitializedModelElement)project).isInitialized()) {
                return StructuredSelection.EMPTY;
            }
            if (!BeansCoreUtils.isBeansConfig((IResource)resource)) {
                return null;
            }
            int startLine = document.getLineOfOffset(element.getStartOffset()) + 1;
            IModelElement modelElement = BeansModelUtils.getMostSpecificModelElement((int)startLine, (int)(endLine = document.getLineOfOffset(element.getEndOffset()) + 1), (IFile)resource, (IProgressMonitor)new NullProgressMonitor());
            if (modelElement != null) {
                return new TreeSelection(BeansUIUtils.createTreePath(modelElement));
            }
            return new StructuredSelection((Object)resource);
        }
        return null;
    }
}

