/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelDecorator;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISpringProject;

public class BeansNavigatorDropAdapter
extends CommonDropAdapterAssistant {
    private IBeansModelElement getBeansModelElementFromTarget(IResource resource, Object target) {
        if (target instanceof IWorkspaceRoot) {
            return BeansCorePlugin.getModel().getProject(resource.getProject());
        }
        if (target instanceof ISpringProject) {
            return BeansCorePlugin.getModel().getProject(((ISpringProject)target).getProject());
        }
        if (target instanceof IBeansModelElement) {
            return (IBeansModelElement)target;
        }
        return null;
    }

    private IProject getProject(IBeansModelElement modelElement) {
        IBeansProject beansProject = BeansModelUtils.getProject((IModelElement)modelElement);
        if (beansProject != null) {
            return beansProject.getProject();
        }
        return null;
    }

    private IResource getResourceFromDropTarget(DropTargetEvent dropTargetEvent) {
        Object object = dropTargetEvent.data;
        if (object instanceof ITreeSelection) {
            object = ((ITreeSelection)object).getFirstElement();
        }
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            return (IResource)((IAdaptable)object).getAdapter(IResource.class);
        }
        return null;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        IResource resource = this.getResourceFromDropTarget(dropTargetEvent);
        if (SpringCoreUtils.isSpringProject((IResource)resource) && resource instanceof IFile) {
            IFile file = (IFile)resource;
            IBeansModelElement parent = this.getBeansModelElementFromTarget(resource, target);
            if (parent instanceof BeansProject) {
                BeansProject beansProject = (BeansProject)parent;
                IProject project = this.getProject(parent);
                if (resource.getProject().equals((Object)project) && !beansProject.hasConfig(file)) {
                    beansProject.addConfig(file, IBeansConfig.Type.MANUAL);
                    return this.saveProject(beansProject);
                }
            } else if (parent instanceof BeansConfigSet) {
                BeansConfigSet beansConfigSet = (BeansConfigSet)parent;
                IProject project = this.getProject(parent);
                BeansProject beansProject = (BeansProject)BeansCorePlugin.getModel().getProject(project);
                if (!beansProject.isUpdatable()) {
                    return Status.CANCEL_STATUS;
                }
                if (resource.getProject().equals((Object)project) && !beansConfigSet.hasConfig(file)) {
                    IBeansConfig bc = BeansCorePlugin.getModel().getConfig((IFile)resource);
                    if (bc != null) {
                        beansConfigSet.addConfig(bc.getElementName());
                    } else {
                        beansProject.addConfig(file, IBeansConfig.Type.MANUAL);
                        bc = beansProject.getConfig(file);
                        beansConfigSet.addConfig(bc.getElementName());
                    }
                    return this.saveProject(beansProject);
                }
            }
        }
        return Status.CANCEL_STATUS;
    }

    private IStatus saveProject(BeansProject beansProject) {
        beansProject.saveDescription();
        BeansModelLabelDecorator.update();
        return Status.OK_STATUS;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (operation == 1) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }
}

