/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.osgi.targetdefinition;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IStartup;
import org.osgi.framework.Bundle;
import org.springframework.ide.eclipse.osgi.targetdefinition.Activator;
import org.springframework.util.FileCopyUtils;

public class TargetStartup
implements IStartup {
    public void earlyStartup() {
        try {
            Bundle bundle = Activator.getDefault().getBundle();
            IPath root = Activator.getDefault().getStateLocation().append(((String)bundle.getHeaders().get("Bundle-Version")).toString()).append("target");
            File rootFolder = root.toFile();
            Enumeration paths = bundle.getEntryPaths("/release/target/plugins/");
            while (paths.hasMoreElements()) {
                String path = (String)paths.nextElement();
                if (!path.endsWith(".jar")) continue;
                URL url = bundle.getEntry(path);
                int ix = url.getFile().lastIndexOf(47);
                File copy = new File(rootFolder, url.getFile().substring(ix));
                if (copy.exists()) continue;
                if (!rootFolder.exists()) {
                    rootFolder.mkdirs();
                }
                FileCopyUtils.copy((InputStream)url.openStream(), (OutputStream)new FileOutputStream(copy));
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.springframework.ide.eclipse.osgi.targetdefinition", 1, "Error provisioning Spring DM target", (Throwable)e));
        }
    }
}

