/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation.rules;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.SuperTypeHierarchyCache;
import org.springframework.ide.eclipse.core.model.IModelElement;

public final class ValidationRuleUtils {
    public static final String FACTORY_BEAN_REFERENCE_PREFIX = "&";
    public static final String FACTORY_BEAN_REFERENCE_REGEXP = "[&]";
    public static final String ASPECT_OF_METHOD_NAME = "aspectOf";

    public static boolean isFactoryBeanReference(String property) {
        return property.startsWith(FACTORY_BEAN_REFERENCE_PREFIX);
    }

    public static String getBeanClassName(IBean bean) {
        return ValidationRuleUtils.getBeanClassName(bean, BeansModelUtils.getConfig(bean));
    }

    public static String getBeanClassName(IBean bean, IModelElement context) {
        BeanDefinition bd = BeansModelUtils.getMergedBeanDefinition(bean, context);
        if (bd != null) {
            return bd.getBeanClassName();
        }
        return null;
    }

    public static Set<BeanDefinition> getBeanDefinitions(String beanName, String beanClass, IBeansValidationContext context) {
        HashSet<BeanDefinition> beanDefinition = new HashSet<BeanDefinition>();
        try {
            beanDefinition.add(context.getCompleteRegistry().getBeanDefinition(beanName));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        IType[] allSubtypes = null;
        try {
            IType beanClassType = JdtUtils.getJavaType((IProject)context.getRootElementProject(), (String)beanClass);
            ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)beanClassType);
            allSubtypes = hierarchy.getAllSubtypes(beanClassType);
        }
        catch (JavaModelException javaModelException) {}
        String[] stringArray = context.getCompleteRegistry().getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                BeanDefinition db = context.getCompleteRegistry().getBeanDefinition(name);
                if (db.getBeanClassName() != null) {
                    if (db.getBeanClassName().equals(beanClass)) {
                        beanDefinition.add(db);
                    } else if (allSubtypes != null) {
                        int i = 0;
                        while (i < allSubtypes.length) {
                            if (allSubtypes[i].getFullyQualifiedName().equals(db.getBeanClassName()) && allSubtypes[i].exists()) {
                                beanDefinition.add(db);
                            }
                            ++i;
                        }
                    } else if (Introspector.doesExtend((IType)JdtUtils.getJavaType((IProject)context.getRootElementProject(), (String)db.getBeanClassName()), (String)beanClass)) {
                        beanDefinition.add(db);
                    }
                }
            }
            catch (BeanDefinitionStoreException beanDefinitionStoreException) {}
            ++n2;
        }
        return beanDefinition;
    }

    public static IType extractBeanClass(BeanDefinition bd, IBean bean, String mergedClassName, IBeansValidationContext context) {
        IType type = JdtUtils.getJavaType((IProject)BeansModelUtils.getProject(bean).getProject(), (String)mergedClassName);
        if (bd.getFactoryMethodName() != null && bd.getFactoryBeanName() == null) {
            type = ValidationRuleUtils.extractTypeFromFactoryMethod(bd, type);
        } else if (bd.getFactoryMethodName() != null && bd.getFactoryBeanName() != null) {
            try {
                AbstractBeanDefinition factoryBd = (AbstractBeanDefinition)context.getCompleteRegistry().getBeanDefinition(bd.getFactoryBeanName());
                IType factoryBeanType = ValidationRuleUtils.extractBeanClass((BeanDefinition)factoryBd, bean, factoryBd.getBeanClassName(), context);
                if (factoryBeanType != null) {
                    type = ValidationRuleUtils.extractTypeFromFactoryMethod(bd, factoryBeanType);
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        }
        return type;
    }

    private static IType extractTypeFromFactoryMethod(BeanDefinition bd, IType type) {
        String factoryMethod = bd.getFactoryMethodName();
        try {
            int argCount = !bd.isAbstract() ? bd.getConstructorArgumentValues().getArgumentCount() : -1;
            Set methods = Introspector.getAllMethods((IType)type);
            for (IMethod method : methods) {
                if (!factoryMethod.equals(method.getElementName()) || method.getParameterNames().length != argCount) continue;
                type = JdtUtils.getJavaTypeFromSignatureClassName((String)method.getReturnType(), (IType)type);
                break;
            }
        }
        catch (JavaModelException javaModelException) {}
        return type;
    }

    public static String getBeanName(IModelElement element) {
        if (element instanceof IBean) {
            return element.getElementName();
        }
        if (element != null) {
            return ValidationRuleUtils.getBeanName(element.getElementParent());
        }
        return null;
    }
}

