/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.namespaces;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Set;
import org.eclipse.wst.common.uriresolver.internal.URI;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.springframework.beans.factory.xml.DelegatingEntityResolver;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.namespaces.NamespaceUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlCatalogDelegatingEntityResolver
extends DelegatingEntityResolver {
    private final Set<EntityResolver> entityResolvers = NamespaceUtils.getEntityResolvers();

    public XmlCatalogDelegatingEntityResolver(EntityResolver dtdResolver, EntityResolver schemaResolver) {
        super(dtdResolver, schemaResolver);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        URI realUri;
        InputSource inputSource = super.resolveEntity(publicId, systemId);
        if (inputSource != null) {
            return inputSource;
        }
        inputSource = this.resolveEntityViaXmlCatalog(publicId, systemId);
        if (inputSource != null) {
            return inputSource;
        }
        for (EntityResolver entityResolver : this.entityResolvers) {
            try {
                inputSource = entityResolver.resolveEntity(publicId, systemId);
                if (inputSource == null) continue;
                return inputSource;
            }
            catch (Exception e) {
                BeansCorePlugin.log(e);
            }
        }
        URIResolver resolver = URIResolverPlugin.createResolver();
        String uri = resolver.resolvePhysicalLocation(null, publicId, systemId);
        if (uri != null && (realUri = URI.createURI((String)uri)).isFile()) {
            inputSource = new InputSource(new FileInputStream(realUri.toFileString()));
        }
        return inputSource;
    }

    private InputSource resolveEntityViaXmlCatalog(String publicId, String systemId) {
        String resolvedSystemId;
        ICatalog catalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        if (systemId != null) {
            try {
                resolvedSystemId = catalog.resolveSystem(systemId);
                if (resolvedSystemId == null) {
                    resolvedSystemId = catalog.resolveURI(systemId);
                }
                if (resolvedSystemId != null) {
                    return new InputSource(resolvedSystemId);
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        if (!(publicId == null || systemId != null && systemId.endsWith(".xsd"))) {
            try {
                resolvedSystemId = catalog.resolvePublic(publicId, systemId);
                if (resolvedSystemId == null) {
                    resolvedSystemId = catalog.resolveURI(publicId);
                }
                if (resolvedSystemId != null) {
                    return new InputSource(resolvedSystemId);
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

