/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConnection;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphPlugin;
import org.springframework.ide.eclipse.beans.ui.graph.editor.GraphEditorInput;
import org.springframework.ide.eclipse.beans.ui.graph.figures.BeanFigure;
import org.springframework.ide.eclipse.beans.ui.graph.model.Bean;
import org.springframework.ide.eclipse.beans.ui.graph.model.ConstructorArgument;
import org.springframework.ide.eclipse.beans.ui.graph.model.IGraphContentExtender;
import org.springframework.ide.eclipse.beans.ui.graph.model.Property;
import org.springframework.ide.eclipse.beans.ui.graph.model.Reference;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class Graph
implements IAdaptable {
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String GRAPH_CONTENT_EXTENDER_EXTENSION_POINT = "org.springframework.ide.eclipse.beans.ui.graph.graphContentExtender";
    private static final int MAX_ORPHAN_ROW_WIDTH = 600;
    private static final Insets DEFAULT_PADDING = new Insets(16);
    private static final String ERROR_TITLE = "Graph.error.title";
    private GraphEditorInput input;
    private DirectedGraph graph;
    private Map<String, Bean> beans = new HashMap<String, Bean>();
    private List<Reference> beanReferences = new ArrayList<Reference>();
    private String elementId;
    private String contextId;

    public Graph() {
        this.graph = new DirectedGraph();
    }

    public Graph(GraphEditorInput input) {
        this.input = input;
        this.elementId = input.getElementId();
        this.contextId = input.getContextId();
    }

    public void init() {
        this.createBeansMap();
        this.createReferences();
        this.extendGraphContent();
        this.graph = new DirectedGraph();
        for (Bean bean : this.beans.values()) {
            this.graph.nodes.add((Object)bean);
        }
        for (Reference reference : this.beanReferences) {
            this.graph.edges.add((Object)reference);
        }
    }

    public Object getAdapter(Class adapter) {
        return this.input.getAdapter(adapter);
    }

    protected Collection getBeans() {
        return this.beans.values();
    }

    protected Bean getBean(String name) {
        return this.beans.get(name);
    }

    public List getNodes() {
        return this.graph.nodes;
    }

    public void layout(Font font) {
        for (Bean bean : this.graph.nodes) {
            BeanFigure dummy = new BeanFigure(bean);
            dummy.setFont(font);
            Dimension size = dummy.getPreferredSize();
            bean.width = size.width;
            bean.height = size.height;
            bean.preferredHeight = size.height;
        }
        Bean root = new Bean();
        this.graph.nodes.add((Object)root);
        EdgeList rootEdges = new EdgeList();
        ArrayList<Bean> orphanBeans = new ArrayList<Bean>();
        for (Bean bean : this.getBeans()) {
            if (bean.incoming.isEmpty() && bean.outgoing.isEmpty()) {
                orphanBeans.add(bean);
                this.graph.nodes.remove((Object)bean);
                continue;
            }
            Reference reference = new Reference(BeansConnection.BeanType.STANDARD, root, bean, false);
            reference.weight = 0;
            rootEdges.add((Object)reference);
            this.graph.edges.add((Object)reference);
        }
        try {
            Edge e;
            new DirectedGraphLayout().visit(this.graph);
            if (!SpringCoreUtils.isEclipseSameOrNewer((int)3, (int)6)) {
                int i = 0;
                while (i < this.graph.edges.size()) {
                    e = this.graph.edges.getEdge(i);
                    if (e.isFeedback()) {
                        e.invert();
                    }
                    ++i;
                }
            }
            int i = 0;
            while (i < rootEdges.size()) {
                e = rootEdges.getEdge(i);
                e.source.outgoing.remove((Object)e);
                e.target.incoming.remove((Object)e);
                this.graph.edges.remove((Object)e);
                ++i;
            }
            this.graph.nodes.remove((Object)root);
            int maxY = 0;
            int maxX = 0;
            int ranks = this.graph.ranks.size();
            if (ranks > 1) {
                int deltaY = this.graph.ranks.getRank((int)1).getNode((int)0).y;
                for (Bean node : this.graph.nodes) {
                    node.y -= deltaY;
                    if (node.y + node.height > maxY) {
                        maxY = node.y + node.height;
                    }
                    if (node.x + node.width <= maxX) continue;
                    maxX = node.x + node.width;
                }
                for (Edge edge : this.graph.edges) {
                    if (edge.vNodes == null) continue;
                    for (Node node : edge.vNodes) {
                        node.y -= deltaY;
                    }
                }
            }
            int x = 0;
            int y = maxY;
            if (maxY > 0) {
                y += DEFAULT_PADDING.getHeight();
            }
            if (maxX < 600) {
                maxX = 600;
            }
            maxY = 0;
            for (Bean bean : orphanBeans) {
                if (x + bean.width > maxX) {
                    x = 0;
                    bean.x = 0;
                    bean.y = y += maxY + DEFAULT_PADDING.getHeight();
                    maxY = bean.height;
                } else {
                    bean.y = y;
                    bean.x = x;
                    if (bean.height > maxY) {
                        maxY = bean.height;
                    }
                }
                x += bean.width + DEFAULT_PADDING.getWidth();
                this.graph.nodes.add((Object)bean);
            }
        }
        catch (RuntimeException e) {
            this.graph = new DirectedGraph();
            this.input.setHasError(true);
            MessageDialog.openError((Shell)BeansGraphPlugin.getActiveWorkbenchWindow().getShell(), (String)BeansGraphPlugin.getResourceString(ERROR_TITLE), (String)e.getMessage());
        }
    }

    protected void extendGraphContent() {
        IExtensionPoint point;
        if (BeansUIPlugin.getDefault().getPluginPreferences().getBoolean("org.springframework.ide.eclipse.beans.ui.shouldExtendedContent") && (point = Platform.getExtensionRegistry().getExtensionPoint(GRAPH_CONTENT_EXTENDER_EXTENSION_POINT)) != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (config.getAttribute(CLASS_ATTRIBUTE) != null) {
                        try {
                            Object provider = config.createExecutableExtension(CLASS_ATTRIBUTE);
                            if (provider instanceof IGraphContentExtender) {
                                ((IGraphContentExtender)provider).addAdditionalBeans(this.beans, this.beanReferences, (IBeansModelElement)this.getElement(this.elementId), (IBeansModelElement)this.getElement(this.contextId));
                            }
                        }
                        catch (CoreException e) {
                            BeansGraphPlugin.log(e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    protected void createBeansMap() {
        LinkedHashSet<IBean> list = new LinkedHashSet<IBean>();
        if (this.getElement(this.elementId) instanceof IBeansConfig) {
            IBeansConfig bc = (IBeansConfig)this.getElement(this.elementId);
            list.addAll(bc.getBeans());
            this.addBeansFromComponents(list, bc.getComponents());
        } else if (this.getElement(this.elementId) instanceof IBeansConfigSet) {
            IBeansConfigSet bcs = (IBeansConfigSet)this.getElement(this.elementId);
            list.addAll(bcs.getBeans());
            this.addBeansFromComponents(list, bcs.getComponents());
        } else if (this.getElement(this.elementId) instanceof IBean) {
            list.add((IBean)this.getElement(this.elementId));
            for (BeansConnection beanRef : BeansModelUtils.getBeanReferences((IModelElement)this.getElement(this.elementId), (IModelElement)this.getElement(this.contextId), (boolean)true)) {
                if (beanRef.getType() == BeansConnection.BeanType.INNER) continue;
                list.add(beanRef.getTarget());
            }
        }
        this.beans = new LinkedHashMap<String, Bean>();
        for (IBean bean : list) {
            if (!this.shouldAddBean(bean)) continue;
            this.beans.put(bean.getElementName(), new Bean(bean));
        }
    }

    private boolean shouldAddBean(IBean bean) {
        return !bean.isInfrastructure() || bean.isInfrastructure() && BeansUIPlugin.getDefault().getPluginPreferences().getBoolean("org.springframework.ide.eclipse.beans.ui.shouldShowInfrastructureBeans");
    }

    private void addBeansFromComponents(Set<IBean> beans, Set<IBeansComponent> components) {
        for (IBeansComponent component : components) {
            Set nestedBeans = component.getBeans();
            for (IBean nestedBean : nestedBeans) {
                if (!this.shouldAddBean(nestedBean)) continue;
                beans.add(nestedBean);
            }
            this.addBeansFromComponents(beans, component.getComponents());
        }
    }

    protected void createReferences() {
        this.beanReferences = new ArrayList<Reference>();
        for (Bean bean : this.beans.values()) {
            Property[] properties;
            ConstructorArgument[] cargs;
            for (BeansConnection beanRef : BeansModelUtils.getBeanReferences((IModelElement)bean.getBean(), (IModelElement)BeansCorePlugin.getModel().getElement(this.contextId), (boolean)false)) {
                Bean targetBean = this.beans.get(beanRef.getTarget().getElementName());
                if (targetBean == null || targetBean == bean || !(beanRef.getSource() instanceof IBean)) continue;
                this.beanReferences.add(new Reference(beanRef.getType(), bean, targetBean, bean, beanRef.isInner()));
            }
            ConstructorArgument[] constructorArgumentArray = cargs = bean.getConstructorArguments();
            int n = cargs.length;
            int n2 = 0;
            while (n2 < n) {
                ConstructorArgument carg = constructorArgumentArray[n2];
                for (BeansConnection beanRef : BeansModelUtils.getBeanReferences((IModelElement)carg.getBeanConstructorArgument(), (IModelElement)BeansCorePlugin.getModel().getElement(this.contextId), (boolean)false)) {
                    Bean targetBean = this.beans.get(beanRef.getTarget().getElementName());
                    if (targetBean == null || targetBean == bean) continue;
                    this.beanReferences.add(new Reference(beanRef.getType(), bean, targetBean, carg, beanRef.isInner()));
                }
                ++n2;
            }
            Property[] propertyArray = properties = bean.getProperties();
            int n3 = properties.length;
            n = 0;
            while (n < n3) {
                Property property = propertyArray[n];
                for (BeansConnection beanRef : BeansModelUtils.getBeanReferences((IModelElement)property.getBeanProperty(), (IModelElement)BeansCorePlugin.getModel().getElement(this.contextId), (boolean)false)) {
                    Bean targetBean = this.beans.get(beanRef.getTarget().getElementName());
                    if (targetBean == null || targetBean == bean) continue;
                    this.beanReferences.add(new Reference(beanRef.getType(), bean, targetBean, property, beanRef.isInner()));
                }
                ++n;
            }
        }
    }

    private IModelElement getElement(String elementId) {
        return BeansCorePlugin.getModel().getElement(elementId);
    }
}

