/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.ui;

import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.JavadocContentAccess;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.metadata.BeansMetadataPlugin;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataReference;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidatorDefinition;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.project.IProjectContributorState;
import org.springframework.ide.eclipse.core.project.ProjectBuilderDefinition;
import org.springframework.ide.eclipse.metadata.MetadataPlugin;
import org.springframework.ide.eclipse.metadata.actions.OpenInBrowserAction;
import org.springframework.ide.eclipse.metadata.actions.OpenInJavaEditorAction;
import org.springframework.ide.eclipse.metadata.actions.ToggleBreakPointAction;
import org.springframework.ide.eclipse.metadata.actions.ToggleLinkingAction;
import org.springframework.ide.eclipse.metadata.actions.ToggleOrientationAction;
import org.springframework.ide.eclipse.metadata.core.RequestMappingAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.core.RequestMappingMethodAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.ui.Messages;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingMethodToClassMap;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingViewContentProvider;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingViewLabelProvider;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingViewSorter;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class RequestMappingView
extends ViewPart
implements ISelectionListener,
ISelectionChangedListener {
    public static int COLUMN_HANDLER_METHOD = 2;
    public static int COLUMN_REQUEST_METHOD = 1;
    public static int COLUMN_URL = 0;
    public static final String ID_VIEW = "com.springsource.sts.ide.metadata.ui.RequestMappingView";
    public static final String PREF_LINKING = "com.springsource.sts.ide.metadata.prefs.linking.RequestMappingView";
    public static final String PREF_ORIENTATION = "com.springsource.sts.ide.metadata.prefs.orientation.RequestMappingView";
    private static final String EMPTY_JAVADOC = Messages.RequestMappingView_DESCRIPTION_EMPTY_JAVADOC;
    private static final String EMPTY_MAPPINGS = Messages.RequestMappingView_DESCRIPTION_EMPTY_REQUESTMAPPINGS;
    private Set<RequestMappingAnnotationMetadata> annotations = new HashSet<RequestMappingAnnotationMetadata>();
    private BaseSelectionListenerAction breakpointAction;
    private IBeansModelElement element;
    private HTMLTextPresenter htmlPresenter;
    private StyledText javadocText;
    private BaseSelectionListenerAction javaEditorAction;
    private RequestMappingViewLabelProvider labelProvider;
    private ToggleLinkingAction linkingAction;
    private boolean linkingEnabled;
    private TableViewer mainViewer;
    private BaseSelectionListenerAction openBrowserAction;
    private ToggleOrientationAction[] orientationActions;
    private IPreferenceStore prefStore = MetadataPlugin.getDefault().getPreferenceStore();
    private ResourceChangeListener resourceListener = new ResourceChangeListener();
    private SashForm splitter;
    private TextPresentation textPresentation;
    private RequestMappingViewSorter viewSorter;

    public RequestMappingView() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
        this.linkingEnabled = this.prefStore.getBoolean(PREF_LINKING);
    }

    public void createPartControl(Composite parent) {
        this.splitter = new SashForm(parent, 0);
        this.createRequestMappingViewer((Composite)this.splitter);
        this.createJavadocViewer((Composite)this.splitter);
        this.initializeColors();
        this.createActions();
        this.hookContextMenu();
        this.fillActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this.mainViewer);
        this.setLinkingEnabled(this.linkingEnabled);
        this.setOrientation(this.prefStore.getInt(PREF_ORIENTATION));
        this.setContentDescription(EMPTY_MAPPINGS);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        this.mainViewer.removeSelectionChangedListener((ISelectionChangedListener)this.openBrowserAction);
        this.mainViewer.removeSelectionChangedListener((ISelectionChangedListener)this.javaEditorAction);
        this.mainViewer.removeSelectionChangedListener((ISelectionChangedListener)this.breakpointAction);
        this.mainViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void finish(int kind, IResourceDelta delta, List<ProjectBuilderDefinition> builderDefinitions, List<ValidatorDefinition> validatorDefinitions, IProjectContributorState state, IProject project) {
        if (this.element == null && this.isLinkingEnabled()) {
            this.setLinkingEnabled(true);
        } else {
            IProject thisProject = null;
            if (this.element instanceof IBeansProject) {
                thisProject = ((IBeansProject)this.element).getProject();
            } else if (this.element != null) {
                thisProject = ((IBeansProject)BeansModelUtils.getParentOfClass((IModelElement)this.element, IBeansProject.class)).getProject();
            }
            if (thisProject != null && thisProject.equals((Object)project)) {
                this.internalSetInput();
            }
        }
    }

    public IBeansModelElement getInput() {
        return this.element;
    }

    public boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof IEditorPart) {
            this.doEditorActivated((IEditorPart)part);
        } else if (!(part instanceof RequestMappingView)) {
            this.doSelectionActivated(selection);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() == this.mainViewer) {
            this.setJavadocInput(event.getSelection());
        }
    }

    public void setFocus() {
        this.mainViewer.getControl().setFocus();
    }

    public void setInput(Object input) {
        if (input instanceof IBeansModelElement) {
            this.element = (IBeansModelElement)input;
            this.internalSetInput();
        }
    }

    public void setLinkingEnabled(boolean enabled) {
        this.linkingEnabled = enabled;
        this.prefStore.setValue(PREF_LINKING, enabled);
        IWorkbenchPage page = this.getSite().getPage();
        if (enabled) {
            page.addSelectionListener((ISelectionListener)this);
            IEditorPart editor = page.getActiveEditor();
            if (editor != null) {
                this.doEditorActivated(editor);
            }
        } else {
            page.removeSelectionListener((ISelectionListener)this);
        }
    }

    public void setOrientation(int orientation) {
        if (orientation != 512) {
            orientation = 256;
        }
        this.splitter.setOrientation(orientation);
        int i = 0;
        while (i < this.orientationActions.length) {
            ToggleOrientationAction action;
            action.setChecked(orientation == (action = this.orientationActions[i]).getOrientation());
            ++i;
        }
        this.prefStore.setValue(PREF_ORIENTATION, orientation);
    }

    private void addAnnotationsForConfig(Set<RequestMappingAnnotationMetadata> newAnnotations, IBeansConfig config) {
        for (IBean bean : BeansModelUtils.getBeans((IModelElement)config)) {
            Set metadataSet = BeansMetadataPlugin.getMetadataModel().getBeanMetadata(bean);
            for (IBeanMetadata metadata : metadataSet) {
                if (!(metadata instanceof RequestMappingAnnotationMetadata)) continue;
                newAnnotations.add((RequestMappingAnnotationMetadata)metadata);
            }
        }
    }

    private void createActions() {
        this.openBrowserAction = new OpenInBrowserAction(this, this.labelProvider);
        this.mainViewer.addSelectionChangedListener((ISelectionChangedListener)this.openBrowserAction);
        this.javaEditorAction = new OpenInJavaEditorAction();
        this.mainViewer.addSelectionChangedListener((ISelectionChangedListener)this.javaEditorAction);
        this.breakpointAction = new ToggleBreakPointAction((IWorkbenchPart)this);
        this.mainViewer.addSelectionChangedListener((ISelectionChangedListener)this.breakpointAction);
        this.linkingAction = new ToggleLinkingAction(this);
        this.orientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, 256), new ToggleOrientationAction(this, 512)};
    }

    private void createJavadocViewer(Composite parent) {
        this.javadocText = new StyledText(parent, 768);
        this.javadocText.setEditable(false);
        this.javadocText.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                RequestMappingView.this.setJavadocInput(RequestMappingView.this.mainViewer.getSelection());
            }
        });
        this.htmlPresenter = new HTMLTextPresenter(false);
        this.textPresentation = new TextPresentation();
    }

    private void createRequestMappingColumns() {
        final Table table = this.mainViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnText = new String[]{Messages.RequestMappingView_HEADER_RESOURCE_URL, Messages.RequestMappingView_HEADER_REQUEST_METHOD, Messages.RequestMappingView_HEADER_HANDLER_METHOD};
        int[] columnWidth = new int[]{200, 150, 300};
        int i = 0;
        while (i < columnText.length) {
            final TableViewerColumn column = new TableViewerColumn(this.mainViewer, 0);
            final int columnId = i;
            column.getColumn().setText(columnText[i]);
            column.getColumn().setWidth(columnWidth[i]);
            column.getColumn().setResizable(true);
            column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (column.getColumn().equals(table.getSortColumn())) {
                        int direction = table.getSortDirection();
                        if (direction == 128) {
                            table.setSortDirection(1024);
                            RequestMappingView.this.viewSorter.setSortDirection(1024);
                        } else {
                            table.setSortDirection(128);
                            RequestMappingView.this.viewSorter.setSortDirection(128);
                        }
                    } else {
                        table.setSortColumn(column.getColumn());
                        RequestMappingView.this.viewSorter.setSortColumn(columnId);
                    }
                    RequestMappingView.this.mainViewer.refresh();
                }
            });
            ++i;
        }
        table.setSortColumn(table.getColumn(COLUMN_URL));
        this.viewSorter.setSortColumn(COLUMN_URL);
        table.setSortDirection(128);
        this.viewSorter.setSortDirection(128);
    }

    private void createRequestMappingViewer(Composite parent) {
        this.mainViewer = new TableViewer(parent, 68356);
        this.labelProvider = new RequestMappingViewLabelProvider();
        this.viewSorter = new RequestMappingViewSorter(this.labelProvider);
        this.createRequestMappingColumns();
        this.mainViewer.setContentProvider((IContentProvider)new RequestMappingViewContentProvider());
        this.mainViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.mainViewer.setSorter((ViewerSorter)this.viewSorter);
        this.mainViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.mainViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RequestMappingView.this.javaEditorAction.run();
            }
        });
    }

    private void doEditorActivated(IEditorPart editor) {
        final IEditorInput editorInput = editor.getEditorInput();
        if (editorInput != null) {
            Job updateFromEditor = new Job("Loading RequestMappings"){

                protected IStatus run(IProgressMonitor monitor) {
                    IBeansModelElement input = RequestMappingView.this.getInputFromEditor(editorInput);
                    if (input != null) {
                        RequestMappingView.this.element = input;
                    } else {
                        RequestMappingView.this.element = null;
                    }
                    RequestMappingView.this.internalSetInput();
                    return Status.OK_STATUS;
                }
            };
            IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.getViewSite().getService(IWorkbenchSiteProgressService.class);
            if (service != null) {
                service.schedule(updateFromEditor, 0L, true);
            } else {
                updateFromEditor.schedule();
            }
        }
    }

    private void doSelectionActivated(ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null) {
            Job updateFromSelection = new Job("Loading RequestMappings"){

                protected IStatus run(IProgressMonitor monitor) {
                    IBeansModelElement input = RequestMappingView.this.getInputFromSelection(obj);
                    if (input != null) {
                        RequestMappingView.this.element = input;
                    } else {
                        RequestMappingView.this.element = null;
                    }
                    RequestMappingView.this.internalSetInput();
                    return Status.OK_STATUS;
                }
            };
            IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.getViewSite().getService(IWorkbenchSiteProgressService.class);
            if (service != null) {
                service.schedule(updateFromSelection, 0L, true);
            } else {
                updateFromSelection.schedule();
            }
        }
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)this.linkingAction);
        toolBar.add((IContributionItem)new Separator());
        int i = 0;
        while (i < this.orientationActions.length) {
            toolBar.add((IAction)this.orientationActions[i]);
            ++i;
        }
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.openBrowserAction);
        manager.add((IAction)this.javaEditorAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.breakpointAction);
    }

    private IMember findJavaMember(Object obj) {
        IType member = null;
        if (obj instanceof RequestMappingAnnotationMetadata) {
            RequestMappingAnnotationMetadata annotation = (RequestMappingAnnotationMetadata)((Object)obj);
            member = (IType)JavaCore.create((String)annotation.getClassHandle());
        } else if (obj instanceof RequestMappingMethodToClassMap) {
            RequestMappingMethodAnnotationMetadata annotation = ((RequestMappingMethodToClassMap)obj).getMethodMetadata();
            member = (IMethod)JdtUtils.getByHandle((String)annotation.getHandleIdentifier());
        }
        return member;
    }

    private String generateJavadoc(IMember member) {
        try {
            Reader reader = JavadocContentAccess.getHTMLContentReader((IMember)member, (boolean)true, (boolean)false);
            if (reader != null) {
                StringBuffer sBuffer = new StringBuffer();
                char[] cBuffer = new char[1024];
                int i = 0;
                while (-1 != (i = reader.read(cBuffer))) {
                    sBuffer.append(cBuffer, 0, i);
                }
                String body = sBuffer.toString();
                reader.close();
                return body;
            }
            return "";
        }
        catch (JavaModelException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.metadata", Messages.RequestMappingView_ERROR_GENERATING_JAVADOC, (Throwable)e));
            return "";
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.metadata", Messages.RequestMappingView_ERROR_GENERATING_JAVADOC, (Throwable)e));
            return "";
        }
    }

    private IBeansModelElement getInputFromEditor(IEditorInput editorInput) {
        IJavaElement javaElement = JavaUI.getEditorInputJavaElement((IEditorInput)editorInput);
        IBeansModelElement modelElement = this.getInputFromJavaElement(javaElement);
        if (modelElement == null && editorInput instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)editorInput).getFile();
            modelElement = this.getInputFromFile(file);
        }
        return modelElement;
    }

    private IBeansModelElement getInputFromFile(IFile file) {
        IBeansConfig modelElement = BeansCorePlugin.getModel().getConfig(file);
        if (modelElement == null) {
            IProject project = file.getProject();
            modelElement = BeansCorePlugin.getModel().getProject(project);
        }
        return modelElement;
    }

    private IBeansModelElement getInputFromJavaElement(IJavaElement javaElement) {
        IJavaProject project;
        IBeansProject modelElement = null;
        if (javaElement != null && (project = javaElement.getJavaProject()) != null) {
            modelElement = BeansCorePlugin.getModel().getProject(project.getProject());
        }
        return modelElement;
    }

    private IBeansModelElement getInputFromSelection(Object obj) {
        if (obj instanceof IBeansModelElement) {
            return (IBeansModelElement)obj;
        }
        if (obj instanceof BeanMetadataReference) {
            return ((BeanMetadataReference)obj).getBeansProject();
        }
        IBeansModelElement modelElement = null;
        if (obj instanceof IJavaElement) {
            modelElement = this.getInputFromJavaElement((IJavaElement)obj);
        }
        if (modelElement == null && obj instanceof IFile) {
            modelElement = this.getInputFromFile((IFile)obj);
        }
        return modelElement;
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ISelection selection = RequestMappingView.this.getViewSite().getSelectionProvider().getSelection();
                if (!selection.isEmpty()) {
                    RequestMappingView.this.fillContextMenu(manager);
                }
            }
        });
        Menu menu = menuManager.createContextMenu(this.mainViewer.getControl());
        this.mainViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.mainViewer);
    }

    private void initializeColors() {
        if (this.getSite().getShell().isDisposed()) {
            return;
        }
        Display display = this.getSite().getShell().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        this.javadocText.setForeground(display.getSystemColor(28));
        this.javadocText.setBackground(display.getSystemColor(29));
    }

    private void internalSetInput() {
        final HashSet<RequestMappingAnnotationMetadata> newAnnotations = new HashSet<RequestMappingAnnotationMetadata>();
        String contentDescription = this.getContentDescription();
        if (this.element == null) {
            contentDescription = EMPTY_MAPPINGS;
        } else if (this.element instanceof IBeansConfig) {
            this.addAnnotationsForConfig(newAnnotations, (IBeansConfig)this.element);
            contentDescription = String.valueOf(Messages.RequestMappingView_PREFIX_CONFIG_FILE) + ((IBeansConfig)this.element).getElementResource().getFullPath().toString();
        } else if (this.element instanceof IBeansConfigSet) {
            for (IBeansConfig config : ((IBeansConfigSet)this.element).getConfigs()) {
                this.addAnnotationsForConfig(newAnnotations, config);
            }
            IModelElement parent = ((IBeansConfigSet)this.element).getElementParent();
            contentDescription = String.valueOf(Messages.RequestMappingView_PREFIX_CONFIG_SET) + parent.getElementName() + "/" + this.element.getElementName();
        } else if (this.element instanceof IBeansProject) {
            for (IBeansConfig config : ((IBeansProject)this.element).getConfigs()) {
                this.addAnnotationsForConfig(newAnnotations, config);
            }
            contentDescription = String.valueOf(Messages.RequestMappingView_PREFIX_PROJECT) + ((IBeansProject)this.element).getElementName();
        }
        final String newContentDescription = contentDescription;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                RequestMappingView.this.setContentDescription(newContentDescription);
                if (!newAnnotations.equals(RequestMappingView.this.annotations)) {
                    RequestMappingView.this.annotations = newAnnotations;
                    RequestMappingView.this.mainViewer.setInput((Object)RequestMappingView.this.annotations);
                }
            }
        });
    }

    private void setJavadocInput(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object obj = structuredSelection.getFirstElement();
            String javadocStr = null;
            IMember member = this.findJavaMember(obj);
            if (member == null) {
                javadocStr = EMPTY_JAVADOC;
            } else {
                javadocStr = this.generateJavadoc(member);
                if (javadocStr == null || javadocStr.trim().length() == 0) {
                    javadocStr = EMPTY_JAVADOC;
                }
            }
            this.textPresentation.clear();
            Rectangle size = this.javadocText.getClientArea();
            javadocStr = this.htmlPresenter.updatePresentation((Drawable)this.javadocText, javadocStr, this.textPresentation, size.width, size.height);
            this.javadocText.setText(javadocStr);
            TextPresentation.applyTextPresentation((TextPresentation)this.textPresentation, (StyledText)this.javadocText);
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (RequestMappingView.this.element != null) {
                if (event.getType() == 2 || event.getType() == 4) {
                    IProject project = null;
                    if (event.getSource() instanceof IWorkspace) {
                        project = (IProject)event.getResource();
                    } else if (event.getSource() instanceof IProject) {
                        project = (IProject)event.getSource();
                    }
                    IBeansProject beansProject = (IBeansProject)BeansModelUtils.getParentOfClass((IModelElement)RequestMappingView.this.element, IBeansProject.class);
                    if (beansProject != null) {
                        IProject elementProject = beansProject.getProject();
                        if (project != null && elementProject != null && elementProject.equals((Object)project)) {
                            RequestMappingView.this.element = null;
                            RequestMappingView.this.internalSetInput();
                        }
                    }
                } else if (event.getType() == 1) {
                    IResourceDelta delta = event.getDelta();
                    try {
                        if (delta != null) {
                            delta.accept((IResourceDeltaVisitor)this);
                        }
                    }
                    catch (CoreException coreException) {
                        StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.metadata", Messages.RequestMappingView_ERROR_PROCESSING_RESOURCE_CHANGE));
                    }
                }
            }
        }

        public boolean visit(IResourceDelta root) throws CoreException {
            IResourceDelta delta;
            IFile file = BeansModelUtils.getFile((IModelElement)RequestMappingView.this.element);
            if (RequestMappingView.this.element != null && root != null && file != null && (delta = root.findMember(file.getFullPath())) != null && delta.getKind() == 2) {
                RequestMappingView.this.element = null;
                RequestMappingView.this.internalSetInput();
            }
            return false;
        }
    }
}

