/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.ui.preferences;

import java.util.LinkedHashSet;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.cli.BootInstallManager;
import org.springframework.ide.eclipse.boot.core.cli.install.IBootInstall;
import org.springframework.ide.eclipse.boot.ui.preferences.InstalledBootInstallBlock;
import org.springframework.ide.eclipse.boot.ui.preferences.SWTFactory;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;

public class BootInstallPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private InstalledBootInstallBlock fJREBlock;
    private BootInstallManager installManager;

    public BootInstallPreferencePage() {
        super("Spring Boot Installations");
    }

    public void init(IWorkbench workbench) {
        try {
            this.installManager = BootInstallManager.getInstance();
        }
        catch (Exception e) {
            throw ExceptionUtil.unchecked((Exception)e);
        }
    }

    public boolean isValid() {
        if (super.isValid() && this.getCurrentDefaultVM() == null && this.fJREBlock.getJREs().length > 0) {
            this.setErrorMessage("Select a default Boot installation");
            return false;
        }
        return true;
    }

    public boolean performOk() {
        boolean[] canceled = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                IBootInstall[] vms;
                LinkedHashSet<IBootInstall> newInstalls = new LinkedHashSet<IBootInstall>();
                IBootInstall defaultVM = BootInstallPreferencePage.this.getCurrentDefaultVM();
                IBootInstall[] iBootInstallArray = vms = BootInstallPreferencePage.this.fJREBlock.getJREs();
                int n = vms.length;
                int n2 = 0;
                while (n2 < n) {
                    IBootInstall vm = iBootInstallArray[n2];
                    try {
                        newInstalls.add(BootInstallPreferencePage.this.installManager.newInstall(vm.getUrl(), vm.getName()));
                    }
                    catch (Exception e) {
                        BootActivator.log(e);
                    }
                    ++n2;
                }
                BootInstallPreferencePage.this.installManager.setDefaultInstall(defaultVM);
                BootInstallPreferencePage.this.installManager.setInstalls(newInstalls);
                BootInstallPreferencePage.this.installManager.save();
            }
        });
        if (canceled[0]) {
            return false;
        }
        IDialogSettings settings = BootActivator.getDefault().getDialogSettings();
        this.fJREBlock.saveColumnSettings(settings, "com.springsource.sts.boot.ui.dialogsettings");
        return super.performOk();
    }

    private IBootInstall getCurrentDefaultVM() {
        return this.fJREBlock.getCheckedJRE();
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        SWTFactory.createWrapLabel(ancestor, "Add, edit or remove Boot installations. By default the checked Boot installation will be used to launch 'app.groovy' Spring Boot CLI scripts", 1, 300);
        SWTFactory.createVerticalSpacer(ancestor, 1);
        this.fJREBlock = new InstalledBootInstallBlock(this.installManager);
        this.fJREBlock.createControl(ancestor);
        this.fJREBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BootInstallPreferencePage.this.isValid();
            }
        });
        Control control = this.fJREBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.fJREBlock.restoreColumnSettings(BootActivator.getDefault().getDialogSettings(), "com.springsource.sts.boot.ui.dialogsettings");
        this.fJREBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BootInstallPreferencePage.this.setValid(false);
                IBootInstall install = BootInstallPreferencePage.this.getCurrentDefaultVM();
                if (install == null) {
                    BootInstallPreferencePage.this.setErrorMessage("Select a default Boot installation");
                } else {
                    BootInstallPreferencePage.this.setErrorMessage(null);
                    BootInstallPreferencePage.this.setValid(true);
                }
            }
        });
        this.applyDialogFont(ancestor);
        return ancestor;
    }
}

