/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.stats.views.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.stats.Messages;
import net.sf.eclipsecs.ui.stats.views.internal.CheckstyleMarkerFilter;
import net.sf.eclipsecs.ui.util.regex.RegExContentAssistProcessor;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contentassist.ContentAssistHandler;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class CheckstyleMarkerFilterDialog
extends TitleAreaDialog {
    private Button mChkFilterEnabled;
    private Button mRadioOnAnyResource;
    private Button mRadioAnyResourceInSameProject;
    private Button mRadioSelectedResource;
    private Button mRadioSelectedResourceAndChildren;
    private Button mRadioSelectedWorkingSet;
    private Label mLblSelectedWorkingSet;
    private Button mBtnWorkingSet;
    private Button mChkSeverityEnabled;
    private Button mChkSeverityError;
    private Button mChkSeverityWarning;
    private Button mChkSeverityInfo;
    private Composite mFilterComposite;
    private Group mGrpRegex;
    private Button mChkSelectByRegex;
    private Label mLblRegexFilter;
    private Button mBtnEditRegex;
    private Button mBtnDefault;
    private CheckstyleMarkerFilter mFilter;
    private IWorkingSet mSelectedWorkingSet;
    private PageController mController = new PageController();
    private List mRegularExpressions;

    public CheckstyleMarkerFilterDialog(Shell shell, CheckstyleMarkerFilter filter) {
        super(shell);
        this.mFilter = filter;
    }

    public CheckstyleMarkerFilter getFilter() {
        return this.mFilter;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite dialog = new Composite(composite, 0);
        dialog.setLayoutData((Object)new GridData(1808));
        dialog.setLayout((Layout)new GridLayout(1, false));
        this.mChkFilterEnabled = new Button(dialog, 32);
        this.mChkFilterEnabled.setText(Messages.CheckstyleMarkerFilterDialog_btnEnabled);
        this.mChkFilterEnabled.addSelectionListener((SelectionListener)this.mController);
        Group onResourceGroup = new Group(dialog, 0);
        onResourceGroup.setText(Messages.CheckstyleMarkerFilterDialog_groupResourceSetting);
        onResourceGroup.setLayout((Layout)new GridLayout(3, false));
        onResourceGroup.setLayoutData((Object)new GridData(768));
        this.mFilterComposite = onResourceGroup;
        this.mRadioOnAnyResource = new Button((Composite)onResourceGroup, 16);
        this.mRadioOnAnyResource.setText(Messages.CheckstyleMarkerFilterDialog_btnOnAnyResource);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.mRadioOnAnyResource.setLayoutData((Object)gd);
        this.mRadioAnyResourceInSameProject = new Button((Composite)onResourceGroup, 16);
        this.mRadioAnyResourceInSameProject.setText(Messages.CheckstyleMarkerFilterDialog_btnOnAnyResourceInSameProject);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.mRadioAnyResourceInSameProject.setLayoutData((Object)gd);
        this.mRadioSelectedResource = new Button((Composite)onResourceGroup, 16);
        this.mRadioSelectedResource.setText(Messages.CheckstyleMarkerFilterDialog_btnOnSelectedResource);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.mRadioSelectedResource.setLayoutData((Object)gd);
        this.mRadioSelectedResourceAndChildren = new Button((Composite)onResourceGroup, 16);
        this.mRadioSelectedResourceAndChildren.setText(Messages.CheckstyleMarkerFilterDialog_btnOnSelectedResourceAndChilds);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.mRadioSelectedResourceAndChildren.setLayoutData((Object)gd);
        this.mRadioSelectedWorkingSet = new Button((Composite)onResourceGroup, 16);
        this.mRadioSelectedWorkingSet.setText(Messages.CheckstyleMarkerFilterDialog_btnOnWorkingSet);
        this.mRadioSelectedWorkingSet.setLayoutData((Object)new GridData());
        this.mLblSelectedWorkingSet = new Label((Composite)onResourceGroup, 0);
        this.mLblSelectedWorkingSet.setLayoutData((Object)new GridData(800));
        this.mBtnWorkingSet = new Button((Composite)onResourceGroup, 8);
        this.mBtnWorkingSet.setText(Messages.CheckstyleMarkerFilterDialog_btnSelect);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.verticalSpan = 2;
        this.mBtnWorkingSet.setLayoutData((Object)gd);
        this.mBtnWorkingSet.addSelectionListener((SelectionListener)this.mController);
        Composite severityGroup = new Composite((Composite)onResourceGroup, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        severityGroup.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        severityGroup.setLayoutData((Object)gd);
        this.mChkSeverityEnabled = new Button(severityGroup, 32);
        this.mChkSeverityEnabled.setText(Messages.CheckstyleMarkerFilterDialog_btnMarkerSeverity);
        this.mChkSeverityEnabled.setLayoutData((Object)new GridData(768));
        this.mChkSeverityEnabled.addSelectionListener((SelectionListener)this.mController);
        this.mChkSeverityError = new Button(severityGroup, 32);
        this.mChkSeverityError.setText(Messages.CheckstyleMarkerFilterDialog_btnSeverityError);
        this.mChkSeverityError.setLayoutData((Object)new GridData());
        this.mChkSeverityWarning = new Button(severityGroup, 32);
        this.mChkSeverityWarning.setText(Messages.CheckstyleMarkerFilterDialog_btnSeverityWarning);
        this.mChkSeverityWarning.setLayoutData((Object)new GridData());
        this.mChkSeverityInfo = new Button(severityGroup, 32);
        this.mChkSeverityInfo.setText(Messages.CheckstyleMarkerFilterDialog_btnSeverityInfo);
        this.mChkSeverityInfo.setLayoutData((Object)new GridData());
        this.mGrpRegex = new Group(dialog, 0);
        this.mGrpRegex.setText(Messages.CheckstyleMarkerFilterDialog_lblExcludeMarkers);
        layout = new GridLayout(3, false);
        this.mGrpRegex.setLayout((Layout)layout);
        gd = new GridData(768);
        this.mGrpRegex.setLayoutData((Object)gd);
        this.mChkSelectByRegex = new Button((Composite)this.mGrpRegex, 32);
        this.mChkSelectByRegex.setText(Messages.CheckstyleMarkerFilterDialog_lblRegex);
        this.mChkSelectByRegex.setLayoutData((Object)new GridData());
        this.mLblRegexFilter = new Label((Composite)this.mGrpRegex, 0);
        gd = new GridData(768);
        gd.widthHint = 100;
        this.mLblRegexFilter.setLayoutData((Object)gd);
        this.mBtnEditRegex = new Button((Composite)this.mGrpRegex, 8);
        this.mBtnEditRegex.setText(Messages.CheckstyleMarkerFilterDialog_btnEdit);
        this.mBtnEditRegex.setLayoutData((Object)new GridData());
        this.mBtnEditRegex.addSelectionListener((SelectionListener)this.mController);
        this.updateUIFromFilter();
        this.setTitleImage(CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.PLUGIN_LOGO));
        this.setTitle(Messages.CheckstyleMarkerFilterDialog_title);
        this.setMessage(Messages.CheckstyleMarkerFilterDialog_titleMessage);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.mBtnDefault = this.createButton(parent, 14, Messages.CheckstyleMarkerFilterDialog_btnRestoreDefault, false);
        this.mBtnDefault.addSelectionListener((SelectionListener)this.mController);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.CheckstyleMarkerFilterDialog_btnShellTitle);
    }

    protected void okPressed() {
        this.updateFilterFromUI();
        super.okPressed();
    }

    private void updateUIFromFilter() {
        this.mChkFilterEnabled.setSelection(this.mFilter.isEnabled());
        this.mRadioOnAnyResource.setSelection(this.mFilter.getOnResource() == 0);
        this.mRadioAnyResourceInSameProject.setSelection(this.mFilter.getOnResource() == 3);
        this.mRadioSelectedResource.setSelection(this.mFilter.getOnResource() == 1);
        this.mRadioSelectedResourceAndChildren.setSelection(this.mFilter.getOnResource() == 2);
        this.mRadioSelectedWorkingSet.setSelection(this.mFilter.getOnResource() == 4);
        this.mSelectedWorkingSet = this.mFilter.getWorkingSet();
        this.initWorkingSetLabel();
        this.mChkSeverityEnabled.setSelection(this.mFilter.getSelectBySeverity());
        this.mChkSeverityError.setSelection((this.mFilter.getSeverity() & 4) > 0);
        this.mChkSeverityWarning.setSelection((this.mFilter.getSeverity() & 2) > 0);
        this.mChkSeverityInfo.setSelection((this.mFilter.getSeverity() & 1) > 0);
        this.mChkSelectByRegex.setSelection(this.mFilter.isFilterByRegex());
        this.mRegularExpressions = this.mFilter.getFilterRegex();
        this.initRegexLabel();
        this.mController.updateControlState();
    }

    private void updateFilterFromUI() {
        this.mFilter.setEnabled(this.mChkFilterEnabled.getSelection());
        if (this.mRadioSelectedResource.getSelection()) {
            this.mFilter.setOnResource(1);
        } else if (this.mRadioSelectedResourceAndChildren.getSelection()) {
            this.mFilter.setOnResource(2);
        } else if (this.mRadioAnyResourceInSameProject.getSelection()) {
            this.mFilter.setOnResource(3);
        } else if (this.mRadioSelectedWorkingSet.getSelection()) {
            this.mFilter.setOnResource(4);
        } else {
            this.mFilter.setOnResource(0);
        }
        this.mFilter.setWorkingSet(this.mSelectedWorkingSet);
        this.mFilter.setSelectBySeverity(this.mChkSeverityEnabled.getSelection());
        int severity = 0;
        if (this.mChkSeverityError.getSelection()) {
            severity |= 4;
        }
        if (this.mChkSeverityWarning.getSelection()) {
            severity |= 2;
        }
        if (this.mChkSeverityInfo.getSelection()) {
            severity |= 1;
        }
        this.mFilter.setSeverity(severity);
        this.mFilter.setFilterByRegex(this.mChkSelectByRegex.getSelection());
        this.mFilter.setFilterRegex(this.mRegularExpressions);
    }

    private void initWorkingSetLabel() {
        if (this.mSelectedWorkingSet == null) {
            this.mLblSelectedWorkingSet.setText(Messages.CheckstyleMarkerFilterDialog_msgNoWorkingSetSelected);
        } else {
            this.mLblSelectedWorkingSet.setText(this.mSelectedWorkingSet.getName());
        }
    }

    private void initRegexLabel() {
        StringBuffer buf = new StringBuffer();
        int size = this.mRegularExpressions != null ? this.mRegularExpressions.size() : 0;
        int i = 0;
        while (i < size) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.mRegularExpressions.get(i));
            ++i;
        }
        if (size == 0) {
            buf.append(Messages.CheckstyleMarkerFilterDialog_msgNoRegexDefined);
        }
        this.mLblRegexFilter.setText(buf.toString());
    }

    private class PageController
    implements SelectionListener {
        private PageController() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == CheckstyleMarkerFilterDialog.this.mChkFilterEnabled || e.widget == CheckstyleMarkerFilterDialog.this.mChkSeverityEnabled) {
                this.updateControlState();
            } else if (CheckstyleMarkerFilterDialog.this.mBtnDefault == e.widget) {
                CheckstyleMarkerFilterDialog.this.mFilter.resetState();
                CheckstyleMarkerFilterDialog.this.updateUIFromFilter();
            } else if (CheckstyleMarkerFilterDialog.this.mBtnWorkingSet == e.widget) {
                IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(CheckstyleMarkerFilterDialog.this.getShell(), false);
                if (CheckstyleMarkerFilterDialog.this.mSelectedWorkingSet != null) {
                    dialog.setSelection(new IWorkingSet[]{CheckstyleMarkerFilterDialog.this.mSelectedWorkingSet});
                }
                if (dialog.open() == 0) {
                    IWorkingSet[] result = dialog.getSelection();
                    if (result != null && result.length > 0) {
                        CheckstyleMarkerFilterDialog.this.mSelectedWorkingSet = result[0];
                    } else {
                        CheckstyleMarkerFilterDialog.this.mSelectedWorkingSet = null;
                    }
                    CheckstyleMarkerFilterDialog.this.initWorkingSetLabel();
                }
            } else if (CheckstyleMarkerFilterDialog.this.mBtnEditRegex == e.widget) {
                ArrayList regex = new ArrayList(CheckstyleMarkerFilterDialog.this.mRegularExpressions);
                RegexDialog dialog = new RegexDialog(CheckstyleMarkerFilterDialog.this.getShell(), regex);
                if (dialog.open() == 0) {
                    CheckstyleMarkerFilterDialog.this.mRegularExpressions = regex;
                    CheckstyleMarkerFilterDialog.this.initRegexLabel();
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void updateControlState() {
            CheckstyleMarkerFilterDialog.this.mFilterComposite.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection());
            CheckstyleMarkerFilterDialog.this.mRadioOnAnyResource.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection());
            CheckstyleMarkerFilterDialog.this.mRadioAnyResourceInSameProject.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection());
            CheckstyleMarkerFilterDialog.this.mRadioSelectedResource.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection());
            CheckstyleMarkerFilterDialog.this.mRadioSelectedResourceAndChildren.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection());
            CheckstyleMarkerFilterDialog.this.mRadioSelectedWorkingSet.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection());
            CheckstyleMarkerFilterDialog.this.mLblSelectedWorkingSet.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection());
            CheckstyleMarkerFilterDialog.this.mBtnWorkingSet.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection() && CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection());
            CheckstyleMarkerFilterDialog.this.mChkSeverityEnabled.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection());
            CheckstyleMarkerFilterDialog.this.mChkSeverityError.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection() && CheckstyleMarkerFilterDialog.this.mChkSeverityEnabled.getSelection());
            CheckstyleMarkerFilterDialog.this.mChkSeverityWarning.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection() && CheckstyleMarkerFilterDialog.this.mChkSeverityEnabled.getSelection());
            CheckstyleMarkerFilterDialog.this.mChkSeverityInfo.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection() && CheckstyleMarkerFilterDialog.this.mChkSeverityEnabled.getSelection());
            CheckstyleMarkerFilterDialog.this.mGrpRegex.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection());
            CheckstyleMarkerFilterDialog.this.mChkSelectByRegex.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection());
            CheckstyleMarkerFilterDialog.this.mLblRegexFilter.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection());
            CheckstyleMarkerFilterDialog.this.mBtnEditRegex.setEnabled(CheckstyleMarkerFilterDialog.this.mChkFilterEnabled.getSelection());
        }
    }

    private class RegexDialog
    extends TitleAreaDialog {
        private ListViewer mListViewer;
        private Button mAddButton;
        private Button mRemoveButton;
        private Text mRegexText;
        private List mFileTypesList;

        public RegexDialog(Shell parentShell, List fileTypes) {
            super(parentShell);
            this.mFileTypesList = fileTypes;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite main = new Composite(composite, 0);
            GridLayout layout = new GridLayout(2, false);
            main.setLayout((Layout)layout);
            GridData gd = new GridData(1808);
            main.setLayoutData((Object)gd);
            Composite controls = new Composite(main, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            controls.setLayout((Layout)layout);
            controls.setLayoutData((Object)new GridData(1808));
            Composite buttons = new Composite(main, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            buttons.setLayout((Layout)layout);
            buttons.setLayoutData((Object)new GridData(1040));
            this.mRegexText = new Text(controls, 18436);
            gd = new GridData(768);
            gd.grabExcessHorizontalSpace = true;
            this.mRegexText.setLayoutData((Object)gd);
            this.mAddButton = new Button(buttons, 8);
            this.mAddButton.setText(Messages.CheckstyleMarkerFilterDialog_btnAdd);
            gd = new GridData(768);
            gd.verticalAlignment = 128;
            this.mAddButton.setLayoutData((Object)gd);
            this.mAddButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String text = RegexDialog.this.mRegexText.getText();
                    if (text.trim().length() > 0) {
                        try {
                            Pattern.compile(text);
                            RegexDialog.this.mFileTypesList.add(text);
                            RegexDialog.this.mListViewer.refresh();
                            RegexDialog.this.mRegexText.setText("");
                        }
                        catch (PatternSyntaxException ex) {
                            RegexDialog.this.setErrorMessage(NLS.bind((String)Messages.CheckstyleMarkerFilterDialog_msgInvalidRegex, (Object)ex.getLocalizedMessage()));
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.mListViewer = new ListViewer(controls, 2820);
            this.mListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.mListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.mListViewer.setInput((Object)this.mFileTypesList);
            gd = new GridData(1808);
            gd.heightHint = 100;
            gd.widthHint = 150;
            gd.grabExcessHorizontalSpace = true;
            this.mListViewer.getControl().setLayoutData((Object)gd);
            this.mRemoveButton = new Button(buttons, 8);
            this.mRemoveButton.setText(Messages.CheckstyleMarkerFilterDialog_btnRemove);
            gd = new GridData(768);
            gd.verticalAlignment = 128;
            this.mRemoveButton.setLayoutData((Object)gd);
            this.mRemoveButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)RegexDialog.this.mListViewer.getSelection();
                    RegexDialog.this.mFileTypesList.remove(selection.getFirstElement());
                    RegexDialog.this.mListViewer.refresh();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ContentAssistHandler.createHandlerForText((Text)this.mRegexText, (SubjectControlContentAssistant)this.createContentAssistant());
            this.setTitle(Messages.CheckstyleMarkerFilterDialog_titleRegexEditor);
            this.setMessage(Messages.CheckstyleMarkerFilterDialog_msgEditRegex);
            return main;
        }

        protected void okPressed() {
            super.okPressed();
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.CheckstyleMarkerFilterDialog_titleRegexEditor);
        }

        private SubjectControlContentAssistant createContentAssistant() {
            SubjectControlContentAssistant contentAssistant = new SubjectControlContentAssistant();
            contentAssistant.setRestoreCompletionProposalSize(CheckstyleUIPlugin.getDefault().getDialogSettings());
            RegExContentAssistProcessor processor = new RegExContentAssistProcessor(true);
            contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
            contentAssistant.setContextInformationPopupOrientation(20);
            contentAssistant.setInformationControlCreator(new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent);
                }
            });
            return contentAssistant;
        }
    }
}

