/******************************************************************************* 
 * Copyright (c) 2009 Red Hat, Inc. 
 * Distributed under license by Red Hat, Inc. All rights reserved. 
 * This program is made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, 
 * and is available at http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Red Hat, Inc. - initial API and implementation 
 ******************************************************************************/
package org.jboss.tools.cdi.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

/**
 * @author Alexey Kazakov
 * 
 * @deprecated use org.jboss.tools.cdi.ui.internal.handlers.AddCDISupportHandler
 *
 */
@Deprecated
public class AddCDISupportAction implements IObjectActionDelegate {

	private ISelection currentSelection;

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction, org.eclipse.ui.IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		IProject project = (IProject) ((IStructuredSelection) currentSelection).getFirstElement();
		final PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), project, CDISettingsPreferencePage.ID, new String[] {CDISettingsPreferencePage.ID}, null);
		CDISettingsPreferencePage page = (CDISettingsPreferencePage)dialog.getSelectedPage();
		page.setEnabledCDISuport(shouldEnable());
		Display.getDefault().asyncExec(new Runnable() {
			public void run() {
				if(dialog.getShell() != null && !dialog.getShell().isDisposed()) {
					dialog.getTreeViewer().getControl().forceFocus();
				}
			}
		});
		dialog.open();
	}

	protected boolean shouldEnable() {
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.currentSelection = selection;
	}
}