/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle;

import de.schlichtherle.io.ArchiveStatistics;
import de.schlichtherle.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;

public abstract class CommandLineUtility {
    final PrintStream out;
    final PrintStream err;
    final ProgressMonitor progressMonitor;

    CommandLineUtility() {
        this(System.out, System.err, true);
    }

    CommandLineUtility(OutputStream out, OutputStream err, boolean autoFlush) {
        if (out == null || err == null) {
            throw new NullPointerException();
        }
        this.out = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out, autoFlush);
        this.err = err instanceof PrintStream ? (PrintStream)err : new PrintStream(err, autoFlush);
        this.progressMonitor = new ProgressMonitor(this.err);
        CommandLineUtility.configKeyManager();
    }

    private static void configKeyManager() {
        String feedback = "de.schlichtherle.key.passwd.swing.InvalidOpenKeyFeedback";
        System.setProperty(feedback, System.getProperty(feedback, "de.schlichtherle.key.passwd.swing.HurlingWindowFeedback"));
        feedback = "de.schlichtherle.key.passwd.swing.InvalidCreateKeyFeedback";
        System.setProperty(feedback, System.getProperty(feedback, "de.schlichtherle.key.passwd.swing.HurlingWindowFeedback"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int run(String[] args) {
        int n;
        try {
            n = this.runWithException(args) ? 0 : 1;
        }
        catch (Throwable throwable) {
            try {
                try {
                    File.umount();
                }
                finally {
                    this.progressMonitor.shutdown();
                }
                throw throwable;
            }
            catch (IllegalUsageException ex) {
                this.err.println(ex.getLocalizedMessage());
                return 1;
            }
            catch (IOException ex) {
                this.err.println(ex.getLocalizedMessage());
                return 1;
            }
        }
        try {
            File.umount();
        }
        finally {
            this.progressMonitor.shutdown();
        }
        return n;
    }

    public abstract boolean runWithException(String[] var1) throws IllegalUsageException, IOException;

    static class ProgressMonitor
    extends Thread {
        private final PrintStream err;
        private final Long[] args = new Long[2];
        private final ArchiveStatistics liveStats = File.getLiveArchiveStatistics();

        ProgressMonitor(PrintStream err) {
            this.err = err;
            this.setPriority(10);
            this.setDaemon(true);
        }

        public void start() {
            if (this.err == System.err || this.err == System.out) {
                super.start();
            }
        }

        public void run() {
            boolean run = false;
            long sleep = 2000L;
            while (true) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException shutdown) {
                    break;
                }
                this.showProgress();
                sleep = 200L;
                run = true;
            }
            if (run) {
                this.showProgress();
                this.err.println();
            }
        }

        private void showProgress() {
            this.args[0] = new Long((this.liveStats.getUpdateTotalByteCountRead() + 1023L) / 1024L);
            this.args[1] = new Long((this.liveStats.getUpdateTotalByteCountWritten() + 1023L) / 1024L);
            this.err.print(MessageFormat.format("Top level archive I/O: {0} / {1} KB        \r", this.args));
            this.err.flush();
        }

        private void shutdown() {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interrupted) {
                interrupted.printStackTrace();
            }
        }
    }

    public static abstract class IllegalUsageException
    extends IllegalArgumentException {
        IllegalUsageException(String msg) {
            super(msg);
        }
    }
}

