/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.figures;

import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.springframework.ide.eclipse.config.graph.figures.ParallelActivityFigure;

public class CollapsibleContainerFigure
extends ParallelActivityFigure {
    private final Expander expander = new Expander();
    private boolean isExpanded = true;

    public CollapsibleContainerFigure(int direction) {
        super(direction);
        this.add((IFigure)this.expander);
    }

    public void addActionListener(ActionListener listener) {
        this.expander.addActionListener(listener);
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension dim = new Dimension();
        dim.width = this.getHeader().getPreferredSize().width;
        dim.width += this.expander.getPreferredSize().width;
        dim.width += this.getInsets().getWidth();
        dim.height = 50;
        return dim;
    }

    protected void handleExpandedStateChanged() {
        if (this.isExpanded) {
            this.expander.close();
        } else {
            this.expander.open();
        }
        this.isExpanded = !this.isExpanded;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        Dimension size = this.expander.getPreferredSize();
        this.expander.setLocation(rect.getLocation());
        this.expander.setSize(size);
        this.header.setLocation(rect.getLocation().translate(this.expander.getSize().width + this.getInsets().getWidth(), 0));
    }

    private class Expander
    extends Clickable {
        private final Triangle triangle;

        public Expander() {
            this.setStyle(Clickable.STYLE_TOGGLE);
            this.triangle = new Triangle();
            this.triangle.setSize(10, 10);
            this.triangle.setBackgroundColor(ColorConstants.black);
            this.triangle.setForegroundColor(ColorConstants.black);
            this.triangle.setFill(true);
            this.triangle.setDirection(4);
            this.triangle.setLocation(new Point(5, 3));
            this.setLayoutManager((LayoutManager)new FreeformLayout());
            this.add((IFigure)this.triangle);
            this.setPreferredSize(15, 15);
            this.addChangeListener(new ChangeListener(){

                public void handleStateChanged(ChangeEvent event) {
                    if (event.getPropertyName().equals("selected")) {
                        CollapsibleContainerFigure.this.handleExpandedStateChanged();
                    } else if (event.getPropertyName().equals("mouseover")) {
                        Expander.this.repaint();
                    }
                }
            });
        }

        protected void open() {
            this.triangle.setDirection(4);
        }

        protected void close() {
            this.triangle.setDirection(16);
        }
    }
}

