/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.livegraph.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConnectToApplicationDialog
extends Dialog {
    private Label description;
    private String serviceUrl = "service:jmx:rmi:///jndi/rmi://127.0.0.1:6969/jmxrmi";
    private String appName = "";
    private String username;
    private String password;

    public ConnectToApplicationDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Connect to Application...");
        Composite control = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(control, 0);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.description = new Label(composite, 0);
        this.description.setText("Enter a JMX service URL and application name");
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.description);
        Label serviceLabel = new Label(composite, 0);
        serviceLabel.setText("Service URL:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)serviceLabel);
        final Text serviceText = new Text(composite, 2048);
        serviceText.setText(this.serviceUrl);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(350, -1).applyTo((Control)serviceText);
        serviceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectToApplicationDialog.this.serviceUrl = serviceText.getText();
                ConnectToApplicationDialog.this.update();
            }
        });
        Label serviceHint = new Label(composite, 0);
        serviceHint.setText("ex: service:jmx:rmi://localhost/jndi/rmi://localhost:1099/jmxrmi");
        GridDataFactory.fillDefaults().align(4, 128).span(2, 1).applyTo((Control)serviceHint);
        Label appLabel = new Label(composite, 0);
        appLabel.setText("Application Name:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)appLabel);
        final Text appText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(350, -1).applyTo((Control)appText);
        appText.setText(this.appName);
        appText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectToApplicationDialog.this.appName = appText.getText();
                ConnectToApplicationDialog.this.update();
            }
        });
        Label authentication = new Label(composite, 0);
        authentication.setText("Server Authentication (if required):");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)authentication);
        Label usernameLabel = new Label(composite, 0);
        usernameLabel.setText("Username:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)usernameLabel);
        final Text usernameText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(350, -1).applyTo((Control)usernameText);
        usernameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectToApplicationDialog.this.username = usernameText.getText();
                ConnectToApplicationDialog.this.update();
            }
        });
        Label passLabel = new Label(composite, 0);
        passLabel.setText("Password:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)passLabel);
        final Text passText = new Text(composite, 0x400800);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(350, -1).applyTo((Control)passText);
        passText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectToApplicationDialog.this.password = passText.getText();
                ConnectToApplicationDialog.this.update();
            }
        });
        return control;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getUsername() {
        return this.username;
    }

    private void update() {
        if (this.serviceUrl == null || this.serviceUrl.length() == 0) {
            this.description.setText("Enter a valid JMX service URL");
            this.getButton(0).setEnabled(false);
        } else if (this.appName == null) {
            this.description.setText("Enter an application name");
            this.getButton(0).setEnabled(false);
        } else {
            this.description.setText("Select OK to proceed");
            this.getButton(0).setEnabled(true);
        }
    }
}

