/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.workingsets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.springframework.ide.eclipse.ui.SpringUIPlugin;
import org.springframework.ide.eclipse.ui.workingsets.IElementSpecificLabelProvider;
import org.springframework.ide.eclipse.ui.workingsets.IWorkingSetFilter;

public abstract class WorkingSetUtils {
    public static final String EXTENSION_POINT = "org.springframework.ide.eclipse.ui.contentContribution";

    private static <T> Set<T> getExecutableExtension(String attributeName, Class<T> requiredType) {
        HashSet<Object> extensions = new HashSet<Object>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    try {
                        if (config.getAttribute(attributeName) != null) {
                            extensions.add(config.createExecutableExtension(attributeName));
                        }
                    }
                    catch (Exception e) {
                        SpringUIPlugin.log(e);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return extensions;
    }

    public static Set<ITreeContentProvider> getContentProvider() {
        return WorkingSetUtils.getExecutableExtension("contentProvider", ITreeContentProvider.class);
    }

    public static Set<IElementSpecificLabelProvider> getLabelProvider() {
        return WorkingSetUtils.getExecutableExtension("labelProvider", IElementSpecificLabelProvider.class);
    }

    public static Set<IWorkingSetFilter> getViewerFilter() {
        return WorkingSetUtils.getExecutableExtension("viewerFilter", IWorkingSetFilter.class);
    }
}

