/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.webflow.graph;

import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.springframework.ide.eclipse.config.core.ConfigCoreUtils;
import org.springframework.ide.eclipse.config.core.formatting.ShallowFormatProcessorXML;
import org.springframework.ide.eclipse.config.core.schemas.WebFlowSchemaConstants;
import org.springframework.ide.eclipse.config.graph.model.commands.AbstractConnectionCreateCommand;
import org.w3c.dom.Node;

public class StateConnectionCreateCommand
extends AbstractConnectionCreateCommand {
    private final ShallowFormatProcessorXML formatter = new ShallowFormatProcessorXML();
    protected String oldTargetId;
    protected String targetId;

    public StateConnectionCreateCommand(ITextEditor textEditor, int lineStyle) {
        super(textEditor, lineStyle);
    }

    public boolean canExecute() {
        if (super.canExecute()) {
            this.oldTargetId = this.sourceElement.getAttribute(WebFlowSchemaConstants.ATTR_TO);
            this.targetId = this.targetElement.getAttribute(WebFlowSchemaConstants.ATTR_ID);
            if (this.targetId != null && this.targetId.trim().length() != 0) {
                return true;
            }
        }
        return false;
    }

    public void execute() {
        IDOMDocument document = (IDOMDocument)this.sourceElement.getOwnerDocument();
        IDOMModel model = document.getModel();
        if (model != null) {
            model.beginRecording((Object)this);
            IDOMElement transition = (IDOMElement)document.createElement(WebFlowSchemaConstants.ELEM_TRANSITION);
            transition.setPrefix(ConfigCoreUtils.getPrefixForNamespaceUri((IDOMDocument)document, (String)WebFlowSchemaConstants.URI));
            this.sourceElement.appendChild((Node)transition);
            this.processor.insertDefaultAttributes(transition);
            this.formatter.formatNode((Node)transition);
            this.formatter.formatNode((Node)this.sourceElement);
            transition.setAttribute(WebFlowSchemaConstants.ATTR_TO, this.targetId);
            model.endRecording((Object)this);
        }
    }
}

