/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.actions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.BeansValidationContext;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.namespaces.ToolAnnotationUtils;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.config.ui.ConfigUiPlugin;
import org.springframework.ide.eclipse.config.ui.actions.Messages;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.internal.model.SpringProject;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ToggleMarkOccurrencesAction
extends Action
implements IPropertyChangeListener,
KeyListener,
MouseListener {
    private final IPreferenceStore prefStore;
    private AbstractConfigEditor editor;
    private final Set<Annotation> annotations;
    public static String STS_MARK_OCCURRENCES = "stsMarkOccurrences";
    private final String MARK_PATH = "icons/mark_occurrences.gif";
    private final String MARK_DISABLED_PATH = "icons/mark_occurrences_disabled.gif";
    private static final String[] ATTRIBUTES_TO_CHECK = new String[]{BeansSchemaConstants.ATTR_ID, BeansSchemaConstants.ATTR_NAME, BeansSchemaConstants.ATTR_PARENT, BeansSchemaConstants.ATTR_REF, BeansSchemaConstants.ATTR_DEPENDS_ON, BeansSchemaConstants.ATTR_BEAN, BeansSchemaConstants.ATTR_LOCAL, BeansSchemaConstants.ATTR_KEY_REF, BeansSchemaConstants.ATTR_VALUE_REF};

    public ToggleMarkOccurrencesAction() {
        super(Messages.getString("ToggleMarkOccurrencesAction.ACTION_LABEL"), 2);
        ImageDescriptor imageDesc = ConfigUiPlugin.imageDescriptorFromPlugin((String)"org.springframework.ide.eclipse.config.ui", (String)"icons/mark_occurrences.gif");
        ImageDescriptor disabledDesc = ConfigUiPlugin.imageDescriptorFromPlugin((String)"org.springframework.ide.eclipse.config.ui", (String)"icons/mark_occurrences_disabled.gif");
        this.setImageDescriptor(imageDesc);
        this.setDisabledImageDescriptor(disabledDesc);
        this.annotations = new HashSet<Annotation>();
        this.prefStore = ConfigUiPlugin.getDefault().getPreferenceStore();
        this.prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.setChecked(this.prefStore.getBoolean(STS_MARK_OCCURRENCES));
    }

    private Set<OccurrenceLocation> findBeanReference(String beanName, BeansValidationContext context) throws BadLocationException {
        HashSet<OccurrenceLocation> result = new HashSet<OccurrenceLocation>();
        IDOMDocument document = this.editor.getDomDocument();
        if (document != null) {
            NodeList nodes = document.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                result.addAll(this.findBeanReference(beanName, nodes.item(i), context));
                ++i;
            }
        }
        return result;
    }

    private Set<OccurrenceLocation> findBeanReference(String beanName, Node node, BeansValidationContext context) throws BadLocationException {
        NodeList nodes;
        HashSet<OccurrenceLocation> result = new HashSet<OccurrenceLocation>();
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                AttrImpl attribute = (AttrImpl)attributes.item(i);
                result.addAll(this.findBeanReferences(beanName, attribute, node, context));
                ++i;
            }
        }
        if ((nodes = node.getChildNodes()) != null && nodes.getLength() > 0) {
            int i = 0;
            while (i < nodes.getLength()) {
                Node child = nodes.item(i);
                if (child.getNodeType() == 1) {
                    result.addAll(this.findBeanReference(beanName, child, context));
                }
                ++i;
            }
        }
        return result;
    }

    private Set<OccurrenceLocation> findBeanReferences(String beanName, AttrImpl attribute, Node node, BeansValidationContext context) {
        HashSet<OccurrenceLocation> result = new HashSet<OccurrenceLocation>();
        String attrName = attribute.getName();
        if (attrName != null) {
            boolean found = false;
            String[] stringArray = ATTRIBUTES_TO_CHECK;
            int n = ATTRIBUTES_TO_CHECK.length;
            int n2 = 0;
            while (n2 < n) {
                String attributeName = stringArray[n2];
                if (attributeName.equals(attrName)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (context != null) {
                for (ToolAnnotationUtils.ToolAnnotationData annotationData : context.getToolAnnotation(node, attribute.getLocalName())) {
                    if (!"ref".equals(annotationData.getKind())) continue;
                    found = true;
                }
            }
            if (found && beanName.equals(attribute.getValue())) {
                try {
                    int offset = attribute.getValueRegionStartOffset();
                    int length = beanName.length();
                    if (this.editor.getTextViewer().getDocument().getChar(offset) == '\"') {
                        ++offset;
                    }
                    result.add(new OccurrenceLocation(offset, length));
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return result;
    }

    private Set<OccurrenceLocation> findLocations(IndexedRegion region, int offset) {
        if (region instanceof IDOMNode) {
            String beanName;
            IDOMNode node = (IDOMNode)region;
            IFile file = this.editor.getResourceFile();
            BeansValidationContext context = null;
            IBeansConfig config = BeansCorePlugin.getModel().getConfig(file);
            if (config != null) {
                context = new BeansValidationContext(config, (IResourceModelElement)new SpringProject(SpringCore.getModel(), file.getProject()));
            }
            if ((beanName = this.getBeanName(node, offset, context)) != null) {
                try {
                    return this.findBeanReference(beanName, context);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
        return new HashSet<OccurrenceLocation>();
    }

    private String getBeanName(IDOMNode node, int offset, BeansValidationContext context) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                AttrImpl attribute = (AttrImpl)attributes.item(i);
                if (attribute != null && attribute.getStartOffset() <= offset && attribute.getEndOffset() >= offset) {
                    if (context != null) {
                        List toolAnnotations = context.getToolAnnotation((Node)node, attribute.getLocalName());
                        for (ToolAnnotationUtils.ToolAnnotationData toolAnnotation : toolAnnotations) {
                            if (!"ref".equals(toolAnnotation.getKind())) continue;
                            return attribute.getNodeValue();
                        }
                    }
                    String[] stringArray = ATTRIBUTES_TO_CHECK;
                    int n = ATTRIBUTES_TO_CHECK.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String attributeName = stringArray[n2];
                        if (attributeName.equals(attribute.getNodeName())) {
                            return attribute.getNodeValue();
                        }
                        ++n2;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.selectionChanged();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.selectionChanged();
    }

    public void mouseUp(MouseEvent e) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (STS_MARK_OCCURRENCES.equals(property)) {
            this.setChecked(this.prefStore.getBoolean(STS_MARK_OCCURRENCES));
        }
    }

    public void run() {
        this.prefStore.setValue(STS_MARK_OCCURRENCES, this.isChecked());
        this.selectionChanged();
    }

    private void selectionChanged() {
        if (this.editor != null) {
            if (this.prefStore.getBoolean(STS_MARK_OCCURRENCES)) {
                ISelection selection = this.editor.getTextViewer().getSelection();
                if (selection instanceof ITextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection;
                    int offset = textSelection.getOffset();
                    IndexedRegion node = BeansEditorUtils.getNodeAt((ITextViewer)this.editor.getTextViewer(), (int)offset);
                    Set<OccurrenceLocation> locations = this.findLocations(node, offset);
                    this.updateAnnotations(locations);
                }
            } else if (this.annotations.size() > 0) {
                this.updateAnnotations(new HashSet<OccurrenceLocation>());
                this.annotations.clear();
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChanged();
    }

    public void setActiveEditor(AbstractConfigEditor targetEditor) {
        StyledText textWidget;
        if (this.editor != null && this.editor.getTextViewer() != null && this.editor.getTextViewer().getTextWidget() != null) {
            textWidget = this.editor.getTextViewer().getTextWidget();
            textWidget.removeMouseListener((MouseListener)this);
            textWidget.removeKeyListener((KeyListener)this);
            this.updateAnnotations(new HashSet<OccurrenceLocation>());
        }
        this.editor = targetEditor;
        this.setChecked(this.prefStore.getBoolean(STS_MARK_OCCURRENCES));
        if (this.editor != null && this.editor.getTextViewer() != null && this.editor.getTextViewer().getTextWidget() != null) {
            textWidget = this.editor.getTextViewer().getTextWidget();
            textWidget.addMouseListener((MouseListener)this);
            textWidget.addKeyListener((KeyListener)this);
        }
        this.selectionChanged();
    }

    private void updateAnnotations(Set<OccurrenceLocation> locations) {
        IAnnotationModel annotationModel = this.editor.getSourcePage().getDocumentProvider().getAnnotationModel((Object)this.editor.getEditorInput());
        if (annotationModel == null) {
            return;
        }
        HashMap<Annotation, Position> newAnnotations = new HashMap<Annotation, Position>();
        for (OccurrenceLocation location : locations) {
            Annotation annotation = new Annotation("org.eclipse.jdt.ui.occurrences", false, "");
            Position position = new Position(location.getOffset(), location.getLength());
            newAnnotations.put(annotation, position);
        }
        if (annotationModel instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.annotations.toArray(new Annotation[this.annotations.size()]), newAnnotations);
        } else {
            for (Annotation annotation : this.annotations) {
                annotationModel.removeAnnotation(annotation);
            }
            for (Annotation annotation : newAnnotations.keySet()) {
                annotationModel.addAnnotation(annotation, (Position)newAnnotations.get(annotation));
            }
        }
        this.annotations.clear();
        this.annotations.addAll(newAnnotations.keySet());
    }

    public static class OccurrenceLocation {
        private final int offset;
        private final int length;

        public OccurrenceLocation(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

