/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.boot.properties.editor.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesReconcileEngine;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertyProblem;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeParser;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.ast.NodeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.ast.YamlFileAST;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile.IndexNavigator;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class YamlASTReconciler {
    private SpringPropertiesReconcileEngine.IProblemCollector problems;
    private TypeUtil typeUtil;

    public YamlASTReconciler(SpringPropertiesReconcileEngine.IProblemCollector problems, TypeUtil typeUtil) {
        this.problems = problems;
        this.typeUtil = typeUtil;
    }

    public void reconcile(YamlFileAST ast, IndexNavigator nav, IProgressMonitor mon) {
        List<Node> nodes = ast.getNodes();
        if (nodes != null && !nodes.isEmpty()) {
            mon.beginTask("Reconcile", nodes.size());
            try {
                for (Node node : nodes) {
                    this.reconcile(node, nav);
                    mon.worked(1);
                }
            }
            finally {
                mon.done();
            }
        }
    }

    protected void reconcile(Node node, IndexNavigator nav) {
        switch (node.getNodeId()) {
            case mapping: {
                for (NodeTuple entry : ((MappingNode)node).getValue()) {
                    this.reconcile(entry, nav);
                }
                break;
            }
            case scalar: {
                if (this.isIgnoreScalarAssignmentTo(nav.getPrefix())) break;
                this.expectMapping(node);
                break;
            }
            default: {
                this.expectMapping(node);
            }
        }
    }

    protected boolean isIgnoreScalarAssignmentTo(String propName) {
        return propName.equals("spring.profiles");
    }

    private void reconcile(NodeTuple entry, IndexNavigator nav) {
        Node keyNode = entry.getKeyNode();
        String key = NodeUtil.asScalar(keyNode);
        if (key == null) {
            this.expectScalar(keyNode);
        } else {
            IndexNavigator subNav = nav.selectSubProperty(key);
            PropertyInfo match = subNav.getExactMatch();
            PropertyInfo extension = subNav.getExtensionCandidate();
            if (match != null && extension != null) {
                return;
            }
            if (match != null) {
                Type type = TypeParser.parse((String)match.getType());
                this.reconcile(entry.getValueNode(), type);
            } else if (extension != null) {
                Node valueNode = entry.getValueNode();
                this.reconcile(valueNode, subNav);
            } else {
                this.unkownProperty(keyNode, subNav.getPrefix());
            }
        }
    }

    private void reconcile(Node node, Type type) {
        if (type != null) {
            switch (node.getNodeId()) {
                case scalar: {
                    this.reconcile((ScalarNode)node, type);
                    break;
                }
                case sequence: {
                    this.reconcile((SequenceNode)node, type);
                    break;
                }
                case mapping: {
                    this.reconcile((MappingNode)node, type);
                    break;
                }
                case anchor: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Missing switch case");
                }
            }
        }
    }

    private void reconcile(MappingNode mapping, Type type) {
        block9: {
            block10: {
                block8: {
                    if (!this.typeUtil.isAtomic(type)) break block8;
                    this.expectType(type, (Node)mapping);
                    break block9;
                }
                if (!TypeUtil.isMap((Type)type) && !TypeUtil.isSequencable((Type)type)) break block10;
                Type keyType = TypeUtil.getKeyType((Type)type);
                Type valueType = TypeUtil.getDomainType((Type)type);
                if (keyType != null) {
                    for (NodeTuple entry : mapping.getValue()) {
                        this.reconcile(entry.getKeyNode(), keyType);
                    }
                }
                if (valueType == null) break block9;
                for (NodeTuple entry : mapping.getValue()) {
                    this.reconcile(entry.getValueNode(), valueType);
                }
                break block9;
            }
            Map props = this.typeUtil.getPropertiesMap(type, TypeUtil.EnumCaseMode.ALIASED);
            if (props != null) {
                for (NodeTuple entry : mapping.getValue()) {
                    Node keyNode = entry.getKeyNode();
                    String key = NodeUtil.asScalar(keyNode);
                    if (key == null) {
                        this.expectBeanPropertyName(keyNode, type);
                    } else if (!props.containsKey(key)) {
                        this.unknownBeanProperty(keyNode, type, key);
                    }
                    if (key == null) continue;
                    Node valNode = entry.getValueNode();
                    this.reconcile(valNode, (Type)props.get(key));
                }
            }
        }
    }

    private void reconcile(SequenceNode seq, Type type) {
        if (this.typeUtil.isAtomic(type)) {
            this.expectType(type, (Node)seq);
        } else if (TypeUtil.isSequencable((Type)type)) {
            Type domainType = TypeUtil.getDomainType((Type)type);
            if (domainType != null) {
                for (Node element : seq.getValue()) {
                    this.reconcile(element, domainType);
                }
            }
        } else {
            this.expectType(type, (Node)seq);
        }
    }

    private void reconcile(ScalarNode scalar, Type type) {
        TypeUtil.ValueParser valueParser;
        String stringValue = scalar.getValue();
        if (!stringValue.contains("${") && (valueParser = this.typeUtil.getValueParser(type)) != null) {
            try {
                valueParser.parse(stringValue);
            }
            catch (Exception exception) {
                this.expectType(type, (Node)scalar);
            }
        }
    }

    private void unkownProperty(Node node, String name) {
        this.warning(node, "Unknown property '" + name + "'");
    }

    private void expectType(Type type, Node node) {
        this.error(node, "Expecting a '" + this.typeUtil.niceTypeName(type) + "' but got " + this.describe(node));
    }

    private void expectScalar(Node node) {
        this.error(node, "Expecting a 'Scalar' node but got " + this.describe(node));
    }

    protected void expectMapping(Node node) {
        this.error(node, "Expecting a 'Mapping' node but got " + this.describe(node));
    }

    private void expectBeanPropertyName(Node keyNode, Type type) {
        this.error(keyNode, "Expecting a bean-property name for object of type '" + this.typeUtil.niceTypeName(type) + "' " + "but got " + this.describe(keyNode));
    }

    private void unknownBeanProperty(Node keyNode, Type type, String name) {
        this.error(keyNode, "Unknown property '" + name + "' for type '" + this.typeUtil.niceTypeName(type) + "'");
    }

    protected void warning(Node node, String msg) {
        int start = node.getStartMark().getIndex();
        int end = node.getEndMark().getIndex();
        this.problems.accept(SpringPropertyProblem.warning((String)msg, (int)start, (int)(end - start)));
    }

    protected void error(Node node, String msg) {
        int start = node.getStartMark().getIndex();
        int end = node.getEndMark().getIndex();
        this.problems.accept(SpringPropertyProblem.error((String)msg, (int)start, (int)(end - start)));
    }

    private String describe(Node node) {
        switch (node.getNodeId()) {
            case scalar: {
                return "'" + ((ScalarNode)node).getValue() + "'";
            }
            case mapping: {
                return "a 'Mapping' node";
            }
            case sequence: {
                return "a 'Sequence' node";
            }
            case anchor: {
                return "a 'Anchor' node";
            }
        }
        throw new IllegalStateException("Missing switch case");
    }
}

