/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.configurationmetadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.configurationmetadata.ConfigurationMetadataItem;
import org.springframework.configurationmetadata.ConfigurationMetadataSource;
import org.springframework.configurationmetadata.RawConfigurationMetadata;

class JsonReader {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final int BUFFER_SIZE = 4096;

    JsonReader() {
    }

    public RawConfigurationMetadata read(InputStream in) throws IOException {
        return this.read(in, DEFAULT_CHARSET);
    }

    public RawConfigurationMetadata read(InputStream in, Charset charset) throws IOException {
        JSONObject json = this.readJson(in, charset);
        List<ConfigurationMetadataSource> groups = this.parseAllSources(json);
        List<ConfigurationMetadataItem> items = this.parseAllItems(json);
        return new RawConfigurationMetadata(groups, items);
    }

    private List<ConfigurationMetadataSource> parseAllSources(JSONObject root) {
        ArrayList<ConfigurationMetadataSource> result = new ArrayList<ConfigurationMetadataSource>();
        if (!root.has("groups")) {
            return result;
        }
        JSONArray sources = root.getJSONArray("groups");
        int i = 0;
        while (i < sources.length()) {
            JSONObject source = sources.getJSONObject(i);
            result.add(this.parseSource(source));
            ++i;
        }
        return result;
    }

    private List<ConfigurationMetadataItem> parseAllItems(JSONObject root) {
        ArrayList<ConfigurationMetadataItem> result = new ArrayList<ConfigurationMetadataItem>();
        if (!root.has("properties")) {
            return result;
        }
        JSONArray items = root.getJSONArray("properties");
        int i = 0;
        while (i < items.length()) {
            JSONObject item = items.getJSONObject(i);
            result.add(this.parseItem(item));
            ++i;
        }
        return result;
    }

    private ConfigurationMetadataSource parseSource(JSONObject json) {
        ConfigurationMetadataSource source = new ConfigurationMetadataSource();
        source.setGroupId(json.getString("name"));
        source.setType(json.optString("type", null));
        source.setDescription(json.optString("description", null));
        source.setSourceType(json.optString("sourceType", null));
        source.setSourceMethod(json.optString("sourceMethod", null));
        return source;
    }

    private ConfigurationMetadataItem parseItem(JSONObject json) {
        ConfigurationMetadataItem item = new ConfigurationMetadataItem();
        item.setId(json.getString("name"));
        item.setType(json.optString("type", null));
        item.setDescription(json.optString("description", null));
        item.setDefaultValue(this.readDefaultValue(json));
        item.setDeprecated(json.optBoolean("deprecated", false));
        item.setSourceType(json.optString("sourceType", null));
        item.setSourceMethod(json.optString("sourceMethod", null));
        return item;
    }

    private Object readDefaultValue(JSONObject json) {
        Object defaultValue = json.opt("defaultValue");
        if (defaultValue instanceof JSONArray) {
            JSONArray array = (JSONArray)defaultValue;
            Object[] content = new Object[array.length()];
            int i = 0;
            while (i < array.length()) {
                content[i] = array.get(i);
                ++i;
            }
            return content;
        }
        return defaultValue;
    }

    private JSONObject readJson(InputStream in, Charset charset) throws IOException {
        try {
            StringBuilder out = new StringBuilder();
            InputStreamReader reader = new InputStreamReader(in, charset);
            char[] buffer = new char[4096];
            int bytesRead = -1;
            while ((bytesRead = reader.read(buffer)) != -1) {
                out.append(buffer, 0, bytesRead);
            }
            JSONObject jSONObject = new JSONObject(out.toString());
            return jSONObject;
        }
        finally {
            in.close();
        }
    }
}

