/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.AbstractRulePanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.EditorUsageMode;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.ListManager;
import net.sourceforge.pmd.eclipse.ui.quickfix.Fix;
import net.sourceforge.pmd.eclipse.ui.quickfix.PMDResolutionGenerator;
import net.sourceforge.pmd.eclipse.util.ResourceManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class QuickFixPanelManager
extends AbstractRulePanelManager {
    private org.eclipse.swt.widgets.List fixerList;
    private ListManager listManager;
    public static final String ID = "fixes";

    public QuickFixPanelManager(String theTitle, EditorUsageMode theMode, ValueChangeListener theListener) {
        super(ID, theTitle, theMode, theListener);
    }

    protected List<Fix> commonFixes() {
        List<Rule> theRules = this.rules.allRules();
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        Fix[] fixSet = PMDResolutionGenerator.fixesFor(theRules.get(0));
        if (fixSet != null) {
            Fix[] fixArray = fixSet;
            int n = fixSet.length;
            int n2 = 0;
            while (n2 < n) {
                Fix fix = fixArray[n2];
                fixes.add(fix);
                ++n2;
            }
        }
        return fixes;
    }

    @Override
    protected void adapt() {
        this.fixerList.removeAll();
        List<Fix> fixes = this.commonFixes();
        for (Fix fix : fixes) {
            this.fixerList.add(fix.getLabel());
        }
    }

    @Override
    protected boolean canManageMultipleRules() {
        return true;
    }

    @Override
    protected void clearControls() {
        this.fixerList.removeAll();
    }

    @Override
    public void showControls(boolean flag) {
        this.fixerList.setVisible(flag);
    }

    public static <T> List<T> shift(List<T> items, int[] indices, int shiftAmt) {
        int[] indexArr = new int[items.size()];
        int currentIdx = 0;
        int i = 0;
        while (i < items.size()) {
            indexArr[i] = currentIdx < indices.length && i == indices[currentIdx] + shiftAmt ? indices[currentIdx++] : i - currentIdx;
            ++i;
        }
        ArrayList<T> out = new ArrayList<T>(indexArr.length);
        int[] nArray = indexArr;
        int n = indexArr.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            out.add(items.get(element));
            ++n2;
        }
        return out;
    }

    public static <T> List<T> shift(List<T> items, int index, int shiftAmt) {
        int start = Math.min(index, index + shiftAmt);
        int end = Math.max(index, index + shiftAmt);
        Collections.rotate(items.subList(start, end), shiftAmt);
        return items;
    }

    @Override
    public Control setupOn(Composite parent) {
        GridData gridData = new GridData(768);
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        panel.setLayout((Layout)layout);
        this.fixerList = new org.eclipse.swt.widgets.List(panel, 2562);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.fixerList.setLayoutData((Object)gridData);
        Composite buttonPanel = new Composite(panel, 0);
        layout = new GridLayout(1, false);
        buttonPanel.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        buttonPanel.setLayoutData((Object)gridData);
        Button shiftUpButton = new Button(buttonPanel, 8);
        shiftUpButton.setToolTipText("Shift up");
        shiftUpButton.setImage(ResourceManager.imageFor("icons/upArrow.png"));
        Button addButton = new Button(buttonPanel, 8);
        addButton.setToolTipText("Add");
        addButton.setImage(ResourceManager.imageFor("icons/add.gif"));
        Button removeButton = new Button(buttonPanel, 8);
        removeButton.setToolTipText("Remove");
        removeButton.setImage(ResourceManager.imageFor("icons/delete.gif"));
        Button shiftDownButton = new Button(buttonPanel, 8);
        shiftDownButton.setToolTipText("Shift down");
        shiftDownButton.setImage(ResourceManager.imageFor("icons/downArrow.png"));
        this.listManager = new ListManager(this.fixerList, shiftUpButton, shiftDownButton, removeButton);
        return panel;
    }

    public static void main(String[] args) {
        ArrayList numbers = new ArrayList();
        Collections.addAll(numbers, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        List newNumbers = QuickFixPanelManager.shift(numbers, 5, 3);
        System.out.println(newNumbers);
    }
}

