/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.jobs;

import net.sf.eclipsecs.core.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class BuildProjectJob
extends Job {
    private IProject[] mProjects;
    private int mKind;

    public BuildProjectJob(IProject project, int buildKind) {
        super(NLS.bind((String)Messages.BuildProjectJob_msgBuildProject, (Object)project.getName()));
        this.mProjects = new IProject[]{project};
        this.mKind = buildKind;
    }

    public BuildProjectJob(IProject[] projects, int buildKind) {
        super(Messages.BuildProjectJob_msgBuildAllProjects);
        this.mProjects = projects;
        this.mKind = buildKind;
    }

    public IStatus run(IProgressMonitor monitor) {
        IStatus status = null;
        try {
            try {
                int i = 0;
                while (i < this.mProjects.length) {
                    if (this.mProjects[i].isOpen() && this.mProjects[i].hasNature("net.sf.eclipsecs.core.CheckstyleNature")) {
                        this.mProjects[i].build(this.mKind, monitor);
                    }
                    ++i;
                }
                status = Status.OK_STATUS;
            }
            catch (CoreException e) {
                status = e.getStatus();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }
}

