/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelDecorator;

public class BeansConfigMoveRefactoringParticipant
extends MoveParticipant {
    private IFile config;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.getArguments().getUpdateReferences() || !(this.getArguments().getDestination() instanceof IFolder)) {
            return null;
        }
        IFolder newName = (IFolder)this.getArguments().getDestination();
        return new ModelChange(this.config, newName);
    }

    public String getName() {
        return "Update references in Spring project configurations";
    }

    protected boolean initialize(Object element) {
        if (element instanceof IFile && BeansCoreUtils.isBeansConfig((IResource)((IResource)element), (boolean)false)) {
            this.config = (IFile)element;
            return true;
        }
        return false;
    }

    private static class ModelChange
    extends Change {
        private final IFile config;
        private final IFolder newName;

        public ModelChange(IFile config, IFolder newName) {
            this.config = config;
            this.newName = newName;
        }

        public Object getModifiedElement() {
            return null;
        }

        public String getName() {
            return "Rename references to '" + this.config.getName() + "' in Spring Model";
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }

        public RefactoringStatus isValid(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            if (pm.isCanceled()) {
                return null;
            }
            for (IBeansProject project : BeansCorePlugin.getModel().getProjects()) {
                boolean updated = false;
                BeansProject beansProject = (BeansProject)project;
                for (IBeansConfigSet configSet : beansProject.getConfigSets()) {
                    IPath newPath;
                    if (!configSet.hasConfig(this.config)) continue;
                    if (this.config.getProject().equals((Object)project.getProject())) {
                        newPath = this.newName.getProjectRelativePath().append(this.config.getName());
                        ((BeansConfigSet)configSet).removeConfig(this.config.getProjectRelativePath().toString());
                        ((BeansConfigSet)configSet).addConfig(newPath.toString());
                    } else {
                        newPath = this.newName.getFullPath().append(this.config.getName());
                        ((BeansConfigSet)configSet).removeConfig(this.config.getFullPath().toString());
                        ((BeansConfigSet)configSet).addConfig(newPath.toString());
                    }
                    updated = true;
                }
                if (project.hasConfig(this.config)) {
                    IPath newPath = this.newName.getProjectRelativePath().append(this.config.getName());
                    ((BeansProject)project).removeConfig(this.config.getProjectRelativePath().toString());
                    ((BeansProject)project).addConfig(newPath.toString(), IBeansConfig.Type.MANUAL);
                    this.removeMarkers(this.config);
                    updated = true;
                }
                if (!updated) continue;
                ((BeansProject)project).saveDescription();
                BeansModelLabelDecorator.update();
            }
            return null;
        }

        private void removeMarkers(IFile file) {
            try {
                IMarker[] markers;
                String originatingResourceValue = file.getFullPath().toString();
                IMarker[] iMarkerArray = markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.springframework.ide.eclipse.core.problemmarker", true, 2);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    if (originatingResourceValue.equals(marker.getAttribute("originatingResource"))) {
                        marker.delete();
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
    }
}

