/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.matcher.internal;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.ui.navigator.util.AopReferenceModelImages;
import org.springframework.ide.eclipse.beans.core.model.IBean;

class PointcutMatchImageDescriptor
extends CompositeImageDescriptor {
    private static final int FLAG_JAVA_ELEMENT = 4;
    private Image baseImage;
    private Point size;
    private int flags;

    public PointcutMatchImageDescriptor(Image baseImage, Object state) {
        this.baseImage = baseImage;
        this.flags = this.getFlags(state);
        this.size = this.getSize();
    }

    protected Point getSize() {
        if (this.size == null) {
            ImageData data = this.baseImage.getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.size;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData background = this.baseImage.getImageData();
        if (background == null) {
            background = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(background, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        int x = 0;
        int y = 0;
        ImageData data = null;
        if ((this.flags & 4) != 0) {
            data = AopReferenceModelImages.DESC_OVR_ADVICE.getImageData();
            this.drawImage(data, x, y);
        }
    }

    protected void setSize(Point size) {
        this.size = size;
    }

    private int getFlags(Object element) {
        int flags = 0;
        if (element instanceof IAopReference) {
            flags |= 4;
        } else if (element instanceof IBean) {
            flags |= 4;
        }
        return flags;
    }

    public int hashCode() {
        return this.baseImage.hashCode() | this.flags | this.size.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !PointcutMatchImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        PointcutMatchImageDescriptor other = (PointcutMatchImageDescriptor)((Object)object);
        return this.baseImage.equals((Object)other.baseImage) && this.flags == other.flags && this.size.equals((Object)other.size);
    }

    public String toString() {
        return this.baseImage.toString();
    }
}

