/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.commons.jira;

import com.atlassian.connector.commons.jira.JIRAActionField;
import com.atlassian.connector.commons.jira.JiraCustomField;
import com.atlassian.connector.commons.jira.JiraDatePickerCustomField;
import com.atlassian.connector.commons.jira.JiraUrlCustomField;
import com.atlassian.jira.rest.client.domain.Field;
import com.atlassian.jira.rest.client.domain.input.FieldInput;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jdom.Attribute;
import org.jdom.Element;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraCustomFieldImpl
implements JiraCustomField {
    private String id;
    protected List<String> values = new ArrayList<String>();
    private BasicKeyType typeKey = BasicKeyType.UNSUPPORTED;
    private String name;

    protected JiraCustomFieldImpl(Builder builder) {
        this(builder.id, builder.name, builder.values, builder.typeKey);
    }

    protected JiraCustomFieldImpl(String id, String name, List<String> values, BasicKeyType typeKey) {
        this.id = id;
        if (values != null) {
            this.values.addAll(values);
        }
        this.typeKey = typeKey;
        this.name = name;
    }

    @Override
    public boolean isSupported() {
        return !BasicKeyType.UNSUPPORTED.equals((Object)this.typeKey);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public BasicKeyType getTypeKey() {
        return this.typeKey;
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFormattedValue() {
        return this.values.size() > 0 ? this.values.get(0) : "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BasicKeyType {
        NUMERIC("com.atlassian.jira.plugin.system.customfieldtypes:float"),
        TEXT("com.atlassian.jira.plugin.system.customfieldtypes:textfield"),
        TEXT_AREA("com.atlassian.jira.plugin.system.customfieldtypes:textarea"),
        URL("com.atlassian.jira.plugin.system.customfieldtypes:url"),
        DATE_PICKER("com.atlassian.jira.plugin.system.customfieldtypes:datepicker"),
        UNSUPPORTED("");

        private final String keyValue;

        private BasicKeyType(String key) {
            this.keyValue = key;
        }

        public String getKeyValue() {
            return this.keyValue;
        }

        public static BasicKeyType getValueOf(String key) {
            BasicKeyType[] basicKeyTypeArray = BasicKeyType.values();
            int n = basicKeyTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                BasicKeyType type = basicKeyTypeArray[n2];
                if (type.getKeyValue().equalsIgnoreCase(key)) {
                    return type;
                }
                ++n2;
            }
            return UNSUPPORTED;
        }

        public FieldInput generateJrJcFieldValue(JIRAActionField field) {
            if (UNSUPPORTED == this) {
                return null;
            }
            List<String> values = field.getValues();
            if (values != null && values.size() > 0) {
                String str = values.get(0);
                if (NUMERIC == this) {
                    return new FieldInput(field.getFieldId(), (Object)Float.valueOf(str != null && str.length() > 0 ? Float.valueOf(str).floatValue() : 0.0f));
                }
                if (DATE_PICKER == this) {
                    if (StringUtils.isEmpty((String)str)) {
                        return new FieldInput(field.getFieldId(), null);
                    }
                    DateTime dt = DateTimeFormat.forPattern((String)"dd/MMM/yy").withLocale(Locale.US).parseDateTime(str);
                    return new FieldInput(field.getFieldId(), (Object)JsonParseUtil.formatDate((DateTime)dt));
                }
                return new FieldInput(field.getFieldId(), (Object)str);
            }
            return new FieldInput(field.getFieldId(), null);
        }
    }

    public static class Builder {
        private BasicKeyType typeKey;
        private String id;
        private String name;
        private List<String> values = new ArrayList<String>();

        public Builder(JSONObject meta, Field field) throws JSONException {
            JSONObject schema = meta.getJSONObject("schema");
            this.typeKey = BasicKeyType.getValueOf(schema.getString("custom"));
            this.name = meta.getString("name");
            String type = schema.getString("type");
            this.id = field.getId();
            this.values = Lists.newArrayList();
            if ("array".equals(type)) {
                this.values.add("[Custom field not supported]");
            } else if (this.typeKey == BasicKeyType.UNSUPPORTED) {
                this.values.add("[Custom field not supported]");
            } else {
                Object value = field.getValue();
                if (value != null) {
                    this.values.add(value.toString());
                }
            }
        }

        public Builder(Element e) {
            if (e != null) {
                Element valuesElement;
                Element nameElement;
                Attribute idAttribute;
                Attribute keyAttribute = e.getAttribute("key");
                if (keyAttribute != null && keyAttribute.getValue() != null) {
                    this.typeKey = BasicKeyType.getValueOf(keyAttribute.getValue());
                }
                if ((idAttribute = e.getAttribute("id")) != null && idAttribute.getValue() != null) {
                    this.id = idAttribute.getValue();
                }
                if ((nameElement = e.getChild("customfieldname")) != null && nameElement.getText() != null) {
                    this.name = nameElement.getText();
                }
                if ((valuesElement = e.getChild("customfieldvalues")) != null) {
                    int i = 0;
                    while (i < valuesElement.getChildren().size()) {
                        Element singleValueElement = (Element)valuesElement.getChildren().get(i);
                        if (singleValueElement != null && singleValueElement.getValue() != null) {
                            this.values.add(singleValueElement.getValue());
                        }
                        ++i;
                    }
                }
            }
        }

        public JiraCustomField build() {
            switch (this.typeKey) {
                case DATE_PICKER: {
                    return new JiraDatePickerCustomField(this);
                }
                case URL: {
                    return new JiraUrlCustomField(this);
                }
            }
            return new JiraCustomFieldImpl(this);
        }
    }
}

