/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jvmmonitor.internal.agent;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.Agent;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.DataTransferMXBean;

public class DataTransferMXBeanImpl
implements DataTransferMXBean {
    @Override
    public byte[] read(String fileName, int pos, int maxSize) {
        byte[] results = new byte[]{};
        File file = new File(fileName);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            Agent.logError(new Exception(), "Cannot read file: %s", fileName);
            return results;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            try {
                byte[] bytes = new byte[maxSize];
                randomAccessFile = new RandomAccessFile(file, "r");
                randomAccessFile.seek(pos);
                int size = randomAccessFile.read(bytes);
                if (size != -1) {
                    results = Arrays.copyOf(bytes, size);
                }
            }
            catch (IOException e) {
                Agent.logError(e, "Cannot read file: %s", fileName);
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return results;
    }

    @Override
    public String getVersion() {
        return "3.8.1";
    }
}

