/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.springiderules;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.internal.bestpractices.springiderules.RuleUtil;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class UseDedicatedNamespacesRule
implements IValidationRule<IBean, IBeansValidationContext> {
    public static final String RULE_ID = "legacyxmlusage";
    private static Map<String, String> legacyXmlUsageMap = new HashMap<String, String>();

    static {
        legacyXmlUsageMap.put("org.springframework.jndi.JndiObjectFactoryBean", "Consider using namespace syntax, e.g. <jee:jndi-lookup id=\"myId\" jndi-name=\"jdbc/MyDataSource\"/>");
        legacyXmlUsageMap.put("org.springframework.ejb.access.LocalStatelessSessionProxyFactoryBean", "Consider using namespace syntax, e.g. <jee:local-slsb id=\"simpleSlsb\" jndi-name=\"ejb/RentalServiceBean\" business-interface=\"com.foo.service.RentalService\"/>");
        legacyXmlUsageMap.put("org.springframework.ejb.access.SimpleRemoteStatelessSessionProxyFactoryBean", "<jee:remote-slsb id=\"complexRemoteEjb\" jndi-name=\"ejb/MyRemoteBean\" business-interface=\"com.foo.service.RentalService\" ...");
        legacyXmlUsageMap.put("org.springframework.beans.factory.config.ListFactoryBean", "Consider using namespace syntax, e.g. <util:list id=\"myListId\"> <value>myValue1</value> ...");
        legacyXmlUsageMap.put("org.springframework.beans.factory.config.SetFactoryBean", "Consider using namespace syntax, e.g. <util:set id=\"mySetId\"> <value>myValue1</value> ...");
        legacyXmlUsageMap.put("org.springframework.beans.factory.config.MapFactoryBean", "Consider using namespace syntax, e.g. <util:map id=\"myMapId\"> <entry key=\"myKey\" value=\"myValue\"/> ...");
        legacyXmlUsageMap.put("org.springframework.beans.factory.config.FieldRetrievingFactoryBean", "Consider using namespace syntax, e.g. <util:constant static-field=\"com.mydomain.MyClass.MY_CONSTANT\"/>");
        legacyXmlUsageMap.put("org.springframework.transaction.interceptor.TransactionInterceptor", "Consider using namespace syntax, e.g. <tx:advice id=\"txAdvice\" transaction-manager=\"txManager\" ...");
        legacyXmlUsageMap.put("org.springframework.transaction.annotation.AnnotationTransactionAttributeSource", "Consider using namespace syntax, e.g. <tx:annotation-driven transaction-manager=\"txManager\" ...");
        legacyXmlUsageMap.put("org.springframework.transaction.jta.JtaTransactionManager", "Consider using namespace syntax, e.g. <tx:jta-transaction-manager/>");
        legacyXmlUsageMap.put("org.springframework.transaction.jta.OC4JJtaTransactionManager", "Consider using namespace syntax instead of referencing OC4JJtaTransactionManager directly, e.g. <tx:jta-transaction-manager/>");
        legacyXmlUsageMap.put("org.springframework.transaction.jta.WebLogicJtaTransactionManager", "Consider using namespace syntax instead of referencing WebLogicJtaTransactionManager directly, e.g. <tx:jta-transaction-manager/>");
        legacyXmlUsageMap.put("org.springframework.transaction.jta.WebSphereUowTransactionManager", "Consider using namespace syntax instead of referencing WebSphereUowTransactionManager directly, e.g. <tx:jta-transaction-manager/>");
        legacyXmlUsageMap.put("org.springframework.beans.factory.config.PropertyPlaceholderConfigurer", "Consider using namespace syntax, e.g. <context:property-placeholder ...");
    }

    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof IBean;
    }

    public void validate(IBean bean, IBeansValidationContext validationContext, IProgressMonitor progressMonitor) {
        String infoMessage = legacyXmlUsageMap.get(bean.getClassName());
        if (infoMessage != null) {
            try {
                String path;
                String beanDefinition;
                if (bean.getElementResource() != null && bean.getElementResource().isAccessible() && (beanDefinition = RuleUtil.getFileLines(path = bean.getElementResource().getLocation().toString(), bean.getElementStartLine(), bean.getElementEndLine())).indexOf(bean.getClassName()) > 0) {
                    validationContext.info((IResourceModelElement)bean, "legacyxmlusage:" + bean.getClassName(), infoMessage, new ValidationProblemAttribute[0]);
                }
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.bestpractices", "Could not read bean XML", (Throwable)e));
            }
        }
    }
}

