/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class FinalizeImplementationCheck
extends Check {
    public static final String MSG_KEY_MISSED_TRY_FINALLY = "finalize.implementation.missed.try.finally";
    public static final String MSG_KEY_PUBLIC_FINALIZE = "finalize.implementation.public";
    public static final String MSG_KEY_USELESS_FINALIZE = "finalize.implementation.useless";
    public static final String MSG_KEY_MISSED_SUPER_FINALIZE_CALL = "finalize.implementation.missed.super.finalize";
    private static final String FINALIZE_METHOD_NAME = "finalize";

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    public void visitToken(DetailAST methodDefToken) {
        String warningMessage;
        if (FinalizeImplementationCheck.isFinalizeMethodSignature(methodDefToken) && (warningMessage = FinalizeImplementationCheck.validateFinalizeMethod(methodDefToken)) != null) {
            this.log(methodDefToken.getLineNo(), warningMessage, new Object[0]);
        }
    }

    private static String validateFinalizeMethod(DetailAST finalizeMethodToken) {
        String warningMessage = null;
        if (FinalizeImplementationCheck.hasModifier(63, finalizeMethodToken)) {
            DetailAST methodOpeningBrace = finalizeMethodToken.getLastChild();
            DetailAST literalTry = methodOpeningBrace.findFirstToken(95);
            if (literalTry == null) {
                warningMessage = FinalizeImplementationCheck.containsSuperFinalizeCall(methodOpeningBrace) ? MSG_KEY_USELESS_FINALIZE : MSG_KEY_MISSED_TRY_FINALLY;
            } else {
                DetailAST literalFinally = literalTry.findFirstToken(97);
                if (literalFinally != null && !FinalizeImplementationCheck.containsSuperFinalizeCall(literalFinally.getLastChild())) {
                    warningMessage = MSG_KEY_MISSED_SUPER_FINALIZE_CALL;
                }
            }
        } else {
            warningMessage = MSG_KEY_PUBLIC_FINALIZE;
        }
        return warningMessage;
    }

    public static boolean isFinalizeMethodSignature(DetailAST methodDefToken) {
        return !FinalizeImplementationCheck.hasModifier(64, methodDefToken) && FinalizeImplementationCheck.isFinalizeMethodName(methodDefToken) && FinalizeImplementationCheck.isVoid(methodDefToken) && FinalizeImplementationCheck.getParamsCount(methodDefToken) == 0;
    }

    public static boolean hasModifier(int modifierType, DetailAST methodToken) {
        DetailAST modifiersToken = methodToken.getFirstChild();
        return modifiersToken.findFirstToken(modifierType) != null;
    }

    private static boolean isFinalizeMethodName(DetailAST methodDefToken) {
        DetailAST identToken = methodDefToken.findFirstToken(58);
        return FINALIZE_METHOD_NAME.equals(identToken.getText());
    }

    private static boolean isVoid(DetailAST methodDefToken) {
        DetailAST typeToken = methodDefToken.findFirstToken(13);
        return typeToken.findFirstToken(49) != null;
    }

    private static int getParamsCount(DetailAST methodDefToken) {
        return methodDefToken.findFirstToken(20).getChildCount();
    }

    public static boolean isMethodEmpty(DetailAST methodOpeningBraceToken) {
        return methodOpeningBraceToken.getFirstChild().getType() == 73;
    }

    public static boolean containsSuperFinalizeCall(DetailAST openingBrace) {
        DetailAST dotToken;
        DetailAST methodCallToken = openingBrace.getFirstChild().getFirstChild();
        return methodCallToken != null && (dotToken = methodCallToken.getFirstChild()).findFirstToken(79) != null;
    }

    public static boolean hasTryFinallyBlock(DetailAST methodOpeningBrace) {
        DetailAST tryToken = methodOpeningBrace.findFirstToken(95);
        return tryToken != null && tryToken.getLastChild().getType() == 97;
    }
}

