/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ide.eclipse.quickfix.QuickfixImages;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.MarkerResolutionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.StringLiteralTrackedPosition;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;

public class AddQualiferCompletionProposal
extends MarkerResolutionProposal {
    private final BodyDeclaration decl;

    public AddQualiferCompletionProposal(BodyDeclaration decl, ICompilationUnit cu) {
        super("Add @Qualifier", cu, QuickfixImages.getImage(QuickfixImages.ANNOTATION));
        this.decl = decl;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit((ASTNode)this.decl);
        ASTRewrite astRewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRewrite.getAST();
        ImportRewrite importRewrite = this.createImportRewrite(astRoot);
        String qualifiedName = Qualifier.class.getName();
        if (!ProposalCalculatorUtil.containsImport(this.getCompilationUnit(), qualifiedName)) {
            importRewrite.addImport(qualifiedName);
        }
        SingleMemberAnnotation annotation = ast.newSingleMemberAnnotation();
        annotation.setTypeName((Name)ast.newSimpleName("Qualifier"));
        StringLiteral literal = ast.newStringLiteral();
        annotation.setValue((Expression)literal);
        ITrackedNodePosition position = astRewrite.track((ASTNode)literal);
        this.addLinkedPosition(new StringLiteralTrackedPosition(position), true, "Qualifier");
        ChildListPropertyDescriptor property = this.decl instanceof FieldDeclaration ? FieldDeclaration.MODIFIERS2_PROPERTY : MethodDeclaration.MODIFIERS2_PROPERTY;
        ListRewrite listRewrite = astRewrite.getListRewrite((ASTNode)this.decl, property);
        listRewrite.insertFirst((ASTNode)annotation, null);
        return astRewrite;
    }
}

