/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.parsing.AliasDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeanAlias;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.util.ObjectUtils;

public class BeanAlias
extends AbstractBeansModelElement
implements IBeanAlias {
    private String beanName;

    public BeanAlias(IBeansConfig config, AliasDefinition definition) {
        super((IModelElement)config, definition.getAlias(), (BeanMetadataElement)definition);
        this.beanName = definition.getBeanName();
    }

    public int getElementType() {
        return 6;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeanAlias)) {
            return false;
        }
        BeanAlias that = (BeanAlias)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.beanName, (Object)that.beanName)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.beanName);
        return this.getElementType() * hashCode + super.hashCode();
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append(": name=");
        text.append(this.beanName);
        return text.toString();
    }
}

