/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.project;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.io.xml.XMLWriter;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.project.IWebflowProjectDescriptionConstants;
import org.springframework.ide.eclipse.webflow.core.internal.model.project.WebflowProjectDescription;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;

public class WebflowProjectDescriptionWriter
implements IWebflowProjectDescriptionConstants {
    public static void write(IProject project, WebflowProjectDescription description) {
        IFile file = project.getFile((IPath)new Path(".springWebflow"));
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                XMLWriter writer = new XMLWriter((OutputStream)os);
                WebflowProjectDescriptionWriter.write(description, writer);
                writer.flush();
                writer.close();
            }
            finally {
                os.close();
            }
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream(os.toByteArray()), 0, null);
            } else if (SpringCoreUtils.validateEdit((IFile[])new IFile[]{file})) {
                file.setContents((InputStream)new ByteArrayInputStream(os.toByteArray()), 1, null);
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
    }

    protected static void write(WebflowProjectDescription description, XMLWriter writer) throws IOException {
        writer.startTag("webflow-project-description", null);
        writer.printSimpleTag("version", (Object)"1");
        writer.printCDataTag("pluginVersion", (Object)Activator.getPluginVersion());
        WebflowProjectDescriptionWriter.write("configs", "config", description.getConfigs(), writer);
        writer.endTag("webflow-project-description");
    }

    protected static void write(String name, String elementTagName, List<IWebflowConfig> configs, XMLWriter writer) throws IOException {
        writer.startTag(name, null);
        if (configs != null) {
            for (IWebflowConfig config : configs) {
                writer.startTag("config", null);
                writer.printSimpleTag("file", (Object)config.getResource().getProjectRelativePath().toString());
                writer.printCDataTag("name", (Object)config.getName());
                Set<IModelElement> beansConfigs = config.getBeansConfigs();
                if (beansConfigs != null) {
                    for (IModelElement bc : beansConfigs) {
                        writer.printCDataTag("beans-config", (Object)bc.getElementID());
                    }
                }
                writer.endTag("config");
            }
        }
        writer.endTag(name);
    }
}

