/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.InputAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.Mapping;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IInputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IInputMapper;
import org.springframework.ide.eclipse.webflow.core.model.IMapping;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InputMapper
extends AbstractModelElement
implements IInputMapper {
    private List<IInputAttribute> inputAttributes = null;
    private List<IMapping> mappings = null;

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        super.init(node, parent);
        this.inputAttributes = new ArrayList<IInputAttribute>();
        this.mappings = new ArrayList<IMapping>();
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                InputAttribute attr;
                IDOMNode child = (IDOMNode)children.item(i);
                if ("input-attribute".equals(child.getLocalName())) {
                    attr = new InputAttribute();
                    attr.init(child, this);
                    this.inputAttributes.add(attr);
                } else if ("input".equals(child.getLocalName())) {
                    attr = new InputAttribute();
                    attr.init(child, this);
                    this.inputAttributes.add(attr);
                } else if ("mapping".equals(child.getLocalName())) {
                    Mapping map = new Mapping();
                    map.init(child, this);
                    this.mappings.add(map);
                }
                ++i;
            }
        }
    }

    @Override
    public List<IInputAttribute> getInputAttributes() {
        return this.inputAttributes;
    }

    @Override
    public List<IMapping> getMapping() {
        return this.mappings;
    }

    @Override
    public void addInputAttribute(IInputAttribute action) {
        if (!this.inputAttributes.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.inputAttributes.add(action);
            super.firePropertyChange("add_children", new Integer(this.inputAttributes.indexOf(action)), action);
        }
    }

    @Override
    public void addInputAttribute(IInputAttribute action, int i) {
        if (!this.inputAttributes.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.inputAttributes.add(i, action);
            super.firePropertyChange("add_children", new Integer(this.inputAttributes.indexOf(action)), action);
        }
    }

    @Override
    public void removeAllInputAttribute() {
        for (IInputAttribute action : this.inputAttributes) {
            this.getNode().removeChild((Node)action.getNode());
        }
        this.inputAttributes = new ArrayList<IInputAttribute>();
    }

    @Override
    public void removeInputAttribute(IInputAttribute action) {
        if (this.inputAttributes.contains(action)) {
            this.inputAttributes.remove(action);
            this.getNode().removeChild((Node)action.getNode());
            super.fireStructureChange("remove_children", action);
        }
    }

    @Override
    public void addMapping(IMapping action) {
        if (!this.mappings.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.mappings.add(action);
            super.firePropertyChange("add_children", new Integer(this.mappings.indexOf(action)), action);
        }
    }

    @Override
    public void addMapping(IMapping action, int i) {
        if (!this.mappings.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.mappings.add(i, action);
            super.firePropertyChange("add_children", new Integer(this.mappings.indexOf(action)), action);
        }
    }

    @Override
    public void removeAllMapping() {
        for (IMapping action : this.mappings) {
            this.getNode().removeChild((Node)action.getNode());
        }
        this.mappings = new ArrayList<IMapping>();
    }

    @Override
    public void removeMapping(IMapping action) {
        if (this.mappings.contains(action)) {
            this.mappings.remove(action);
            this.getNode().removeChild((Node)action.getNode());
            super.fireStructureChange("remove_children", action);
        }
    }

    @Override
    public void createNew(IWebflowModelElement parent) {
        IDOMNode node = (IDOMNode)parent.getNode().getOwnerDocument().createElement("input-mapper");
        this.init(node, parent);
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IAttribute iAttribute : this.getAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iAttribute.accept(visitor, monitor);
            }
            for (IInputAttribute iInputAttribute : this.getInputAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iInputAttribute.accept(visitor, monitor);
            }
        }
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IWebflowModelElement> children = new ArrayList<IWebflowModelElement>();
        children.addAll(this.getAttributes());
        children.addAll(this.getInputAttributes());
        return children.toArray(new IModelElement[children.size()]);
    }
}

