/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractActionElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.EvaluationResult;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IEvaluateAction;
import org.springframework.ide.eclipse.webflow.core.model.IEvaluationResult;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EvaluateAction
extends AbstractActionElement
implements IEvaluateAction,
ICloneableModelElement<EvaluateAction> {
    private IActionElement.ACTION_TYPE type;
    private IEvaluationResult evaluationResult = null;

    @Override
    public void setType(IActionElement.ACTION_TYPE type) {
        this.type = type;
    }

    @Override
    public IActionElement.ACTION_TYPE getType() {
        return this.type;
    }

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        super.init(node, parent);
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                IDOMNode child = (IDOMNode)children.item(i);
                if ("evaluation-result".equals(child.getLocalName())) {
                    this.evaluationResult = new EvaluationResult();
                    ((EvaluationResult)this.evaluationResult).init(child, this);
                }
                ++i;
            }
        }
    }

    @Override
    public IEvaluationResult getEvaluationResult() {
        return this.evaluationResult;
    }

    @Override
    public String getExpression() {
        return this.getAttribute("expression");
    }

    @Override
    public void setEvaluationResult(IEvaluationResult evaluationResult) {
        if (this.evaluationResult != null) {
            this.getNode().removeChild((Node)this.evaluationResult.getNode());
        }
        this.evaluationResult = evaluationResult;
        if (evaluationResult != null) {
            WebflowModelXmlUtils.insertNode((Node)evaluationResult.getNode(), (Node)this.getNode());
        }
        super.fireStructureChange("move_children", new Integer(1));
    }

    @Override
    public void setExpression(String expression) {
        this.setAttribute("expression", expression);
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public EvaluateAction cloneModelElement() {
        EvaluateAction state = new EvaluateAction();
        state.init((IDOMNode)this.node.cloneNode(true), this.parent);
        state.setType(this.getType());
        return state;
    }

    @Override
    public void applyCloneValues(EvaluateAction element) {
        if (element != null) {
            if (this.node.getParentNode() != null) {
                this.parent.getNode().replaceChild((Node)element.getNode(), (Node)this.node);
            }
            this.setType(element.getType());
            this.init(element.getNode(), this.parent);
            super.fireStructureChange("move_children", new Integer(0));
            super.firePropertyChange("properties");
        }
    }

    @Override
    public String getScope() {
        return this.getAttribute("scope");
    }

    @Override
    public void setScope(String scope) {
        this.setAttribute("scope", scope);
    }

    @Override
    public void createNew(IWebflowModelElement parent) {
        IDOMNode node = null;
        node = WebflowModelXmlUtils.isVersion1Flow(this) ? (IDOMNode)parent.getNode().getOwnerDocument().createElement("evaluate-action") : (IDOMNode)parent.getNode().getOwnerDocument().createElement("evaluate");
        this.init(node, parent);
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IAttribute state : this.getAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                state.accept(visitor, monitor);
            }
            if (this.getEvaluationResult() != null) {
                this.getEvaluationResult().accept(visitor, monitor);
            }
        }
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IWebflowModelElement> children = new ArrayList<IWebflowModelElement>();
        children.addAll(this.getAttributes());
        children.add(this.getEvaluationResult());
        return children.toArray(new IModelElement[children.size()]);
    }

    @Override
    public String getResult() {
        return this.getAttribute("result");
    }

    @Override
    public String getResultType() {
        return this.getAttribute("result-type");
    }

    @Override
    public void setResult(String result) {
        this.setAttribute("result", result);
    }

    @Override
    public void setResultType(String resultType) {
        this.setAttribute("result-type", resultType);
    }
}

