/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.figures;

import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.springframework.ide.eclipse.config.graph.figures.ConnectorBorder;
import org.springframework.ide.eclipse.config.graph.figures.SubgraphFigure;

public class BorderedContainerFigure
extends SubgraphFigure {
    private final Expander expander = new Expander();
    private boolean isExpanded = false;

    public BorderedContainerFigure(Label header, int direction) {
        super((IFigure)header, (IFigure)new Label(""), direction);
        this.add((IFigure)this.expander);
        this.setBorder((Border)new ConnectorBorder(direction, 0, 0));
        this.setOpaque(true);
    }

    public void addActionListener(ActionListener listener) {
        this.expander.addActionListener(listener);
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension dim = new Dimension();
        int wHeader = this.getHeader().getPreferredSize().width;
        int wFooter = this.getFooter().getPreferredSize().width;
        dim.width = (wHeader += this.expander.getPreferredSize().width) >= wFooter ? wHeader : wFooter;
        dim.width += this.getInsets().getWidth();
        dim.height = 50;
        return dim;
    }

    protected void handleExpandedStateChanged() {
        if (this.isExpanded) {
            this.expander.close();
        } else {
            this.expander.open();
        }
        this.isExpanded = !this.isExpanded;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        this.getClientArea(rect);
        Dimension size = this.expander.getPreferredSize();
        this.expander.setSize(size);
        int dy = 0;
        int headerHeight = this.header.getBounds().height;
        int expanderHeight = this.expander.getBounds().height;
        if (headerHeight > expanderHeight) {
            dy = (headerHeight - expanderHeight) / 2;
        }
        this.expander.setLocation(rect.getTopLeft().translate(0, dy));
        this.header.translate(this.expander.getSize().width, 0);
        this.footer.setLocation(new Point(0, 0));
        this.footer.setSize(0, 0);
    }

    private class Expander
    extends Clickable {
        private final Triangle triangle;

        public Expander() {
            this.setStyle(Clickable.STYLE_TOGGLE);
            this.triangle = new Triangle();
            this.triangle.setSize(10, 10);
            this.triangle.setBackgroundColor(ColorConstants.black);
            this.triangle.setForegroundColor(ColorConstants.black);
            this.triangle.setFill(true);
            this.triangle.setDirection(16);
            this.triangle.setLocation(new Point(5, 3));
            this.setLayoutManager((LayoutManager)new FreeformLayout());
            this.add((IFigure)this.triangle);
            this.setPreferredSize(15, 15);
            this.addChangeListener(new ChangeListener(){

                public void handleStateChanged(ChangeEvent event) {
                    if (event.getPropertyName().equals("selected")) {
                        BorderedContainerFigure.this.handleExpandedStateChanged();
                    } else if (event.getPropertyName().equals("mouseover")) {
                        Expander.this.repaint();
                    }
                }
            });
        }

        protected void open() {
            this.triangle.setDirection(4);
        }

        protected void close() {
            this.triangle.setDirection(16);
        }
    }
}

