/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.views.PriorityFilter;
import net.sourceforge.pmd.eclipse.ui.views.RefreshableTablePage;
import net.sourceforge.pmd.eclipse.ui.views.TableColumnSorter;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutline;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutlineContentProvider;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutlineLabelProvider;
import net.sourceforge.pmd.eclipse.ui.views.actions.RemoveViolationAction;
import net.sourceforge.pmd.util.NumericConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.Page;

public class ViolationOutlinePage
extends Page
implements IPage,
ISelectionChangedListener,
RefreshableTablePage {
    private TableViewer tableViewer;
    private ViolationOutline violationOutline;
    private ViewerFilter viewerFilter;
    private FileRecord resource;
    protected final Integer[] columnWidths = new Integer[]{20, 170, 40};
    protected final int[] columnSortOrder = new int[]{1, 1, 1};
    protected int currentSortedColumn;

    public ViolationOutlinePage(FileRecord resourceRecord, ViolationOutline outline) {
        this.resource = resourceRecord;
        this.violationOutline = outline;
        ViewerFilter[] filters = outline.getFilters();
        int i = 0;
        while (i < filters.length) {
            if (filters[i] instanceof PriorityFilter) {
                this.viewerFilter = filters[i];
            }
            ++i;
        }
    }

    @Override
    public TableViewer tableViewer() {
        return this.tableViewer;
    }

    public void createControl(Composite parent) {
        int tableStyle = 66306;
        this.tableViewer = new TableViewer(parent, tableStyle);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.createColumns(this.tableViewer.getTable());
        this.createActionBars();
        this.violationOutline.createContextMenu(this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)new ViolationOutlineContentProvider(this));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ViolationOutlineLabelProvider());
        this.tableViewer.setInput((Object)this.resource);
        this.tableViewer.addFilter(this.viewerFilter);
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void createColumns(Table viewerTable) {
        TableColumn priorityColumn = new TableColumn(viewerTable, 16384);
        priorityColumn.setWidth(20);
        priorityColumn.setResizable(false);
        TableColumn messageColumn = new TableColumn(viewerTable, 16384);
        messageColumn.setWidth(170);
        messageColumn.setText(this.getString("view.outline.column_message"));
        TableColumn lineColumn = new TableColumn(viewerTable, 131072);
        lineColumn.setWidth(40);
        lineColumn.setText(this.getString("view.outline.column_line"));
        this.createColumnAdapters(this.tableViewer.getTable());
        this.tableViewer.setSorter(this.getViewerSorter(0));
    }

    private void createColumnAdapters(Table table) {
        TableColumn[] columns = table.getColumns();
        int k = 0;
        while (k < columns.length) {
            this.columnWidths[k] = columns[k].getWidth();
            final int i = k;
            columns[k].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int n = ViolationOutlinePage.this.currentSortedColumn = i;
                    ViolationOutlinePage.this.columnSortOrder[n] = ViolationOutlinePage.this.columnSortOrder[n] * -1;
                    ViolationOutlinePage.this.tableViewer.setSorter(ViolationOutlinePage.this.getViewerSorter(ViolationOutlinePage.this.currentSortedColumn));
                }
            });
            columns[k].addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    ViolationOutlinePage.this.columnWidths[i] = ViolationOutlinePage.this.tableViewer.getTable().getColumn(i).getWidth();
                }
            });
            ++k;
        }
    }

    private void createActionBars() {
        IToolBarManager manager = this.getSite().getActionBars().getToolBarManager();
        RemoveViolationAction removeViolationAction = new RemoveViolationAction(this.tableViewer);
        manager.add((IAction)removeViolationAction);
        manager.add((IContributionItem)new Separator());
    }

    private ViewerSorter getViewerSorter(int columnNr) {
        TableColumn column = this.tableViewer.getTable().getColumn(columnNr);
        final int sortOrder = this.columnSortOrder[columnNr];
        switch (columnNr) {
            case 0: {
                return new TableColumnSorter(column, sortOrder){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        IMarker marker1 = (IMarker)e1;
                        IMarker marker2 = (IMarker)e2;
                        Integer prio1 = NumericConstants.ZERO;
                        Integer prio2 = NumericConstants.ZERO;
                        try {
                            prio1 = (Integer)marker1.getAttribute("pmd_priority");
                            prio2 = (Integer)marker2.getAttribute("pmd_priority");
                            if (prio1.equals(prio2)) {
                                prio1 = (Integer)marker1.getAttribute("lineNumber");
                                prio2 = (Integer)marker2.getAttribute("lineNumber");
                            }
                        }
                        catch (CoreException ce) {
                            PMDPlugin.getDefault().logError("message.error.core_exception", ce);
                        }
                        return prio1 == null ? 0 : prio1.compareTo(prio2) * sortOrder;
                    }
                };
            }
            case 1: {
                return new TableColumnSorter(column, sortOrder){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        String message1 = "";
                        String message2 = "";
                        try {
                            message1 = String.valueOf(((IMarker)e1).getAttribute("message"));
                            message2 = String.valueOf(((IMarker)e2).getAttribute("message"));
                        }
                        catch (CoreException ce) {
                            PMDPlugin.getDefault().logError("message.error.core_exception" + ((Object)((Object)this)).toString(), ce);
                        }
                        return message1 == null ? 0 : message1.compareTo(message2) * sortOrder;
                    }
                };
            }
            case 2: {
                return new TableColumnSorter(column, sortOrder){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        try {
                            Integer prio1 = (Integer)((IMarker)e1).getAttribute("lineNumber");
                            Integer prio2 = (Integer)((IMarker)e2).getAttribute("lineNumber");
                            return prio1 == null ? 0 : prio1.compareTo(prio2) * sortOrder;
                        }
                        catch (CoreException ce) {
                            ce.printStackTrace();
                            return 0;
                        }
                    }
                };
            }
        }
        return null;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Control getControl() {
        return this.tableViewer.getControl();
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    public FileRecord getResource() {
        return this.resource;
    }

    public void setColumnWidths(Integer[] widths) {
        if (this.tableViewer.getTable().isDisposed()) {
            return;
        }
        TableColumn[] columns = this.tableViewer.getTable().getColumns();
        int k = 0;
        while (k < widths.length) {
            if (widths[k] == null) {
                widths[k] = k == 0 ? Integer.valueOf(20) : (k == 1 ? Integer.valueOf(170) : Integer.valueOf(40));
            }
            columns[k].setWidth(widths[k].intValue());
            ++k;
        }
        System.arraycopy(widths, 0, this.columnWidths, 0, Math.min(this.columnWidths.length, widths.length));
    }

    public Integer[] getColumnWidths() {
        return this.columnWidths;
    }

    public void setSorterProperties(Integer[] properties) {
        if (properties.length > 0) {
            this.currentSortedColumn = properties[0];
            this.columnSortOrder[this.currentSortedColumn] = properties[1];
            this.tableViewer.setSorter(this.getViewerSorter(this.currentSortedColumn));
        }
    }

    public Integer[] getSorterProperties() {
        return new Integer[]{this.currentSortedColumn, this.columnSortOrder[this.currentSortedColumn]};
    }

    @Override
    public void refresh() {
        if (!this.tableViewer.getControl().isDisposed()) {
            this.tableViewer.getControl().setRedraw(false);
            this.tableViewer.refresh();
            this.tableViewer.getControl().setRedraw(true);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IEditorInput input;
        IEditorPart editor;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        IMarker marker = (IMarker)selection.getFirstElement();
        if (marker != null && (editor = this.getSite().getPage().getActiveEditor()) != null && (input = editor.getEditorInput()) instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            if (marker.getResource().equals((Object)file)) {
                IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            }
        }
    }

    private String getString(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }
}

