/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.quickfix;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.quickfix.Fix;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;

public class PMDResolution
implements IMarkerResolution,
IRunnableWithProgress {
    private static final Logger log = Logger.getLogger(PMDResolution.class);
    private Fix fix;
    private IFile file;
    private int lineNumber;

    public PMDResolution(Fix fix) {
        this.fix = fix;
    }

    public String getLabel() {
        return this.fix.getLabel();
    }

    public void run(IMarker marker) {
        log.debug((Object)"fixing...");
        IResource resource = marker.getResource();
        this.lineNumber = marker.getAttribute("lineNumber", 0);
        if (resource instanceof IFile) {
            this.file = (IFile)resource;
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                dialog.run(false, false, (IRunnableWithProgress)this);
            }
            catch (InvocationTargetException e) {
                this.showError("message.error.invocationtarget_exception", e);
            }
            catch (InterruptedException e) {
                this.showError("message.error.interrupted_exception", e);
            }
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("", 2);
            monitor.subTask(this.file.getName());
            InputStream in = this.file.getContents();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            while (br.ready()) {
                String line = br.readLine();
                pw.println(line);
            }
            monitor.worked(1);
            String fixCode = this.fix.fix(sw.toString(), this.lineNumber);
            this.file.setContents((InputStream)new ByteArrayInputStream(fixCode.getBytes()), false, true, monitor);
            monitor.worked(1);
        }
        catch (CoreException e) {
            this.showError("message.error.core_exception", e);
        }
        catch (IOException e) {
            this.showError("message.error.io_exception", e);
        }
    }

    private void showError(String errorId, Throwable throwable) {
        String error = PMDPlugin.getDefault().getStringTable().getString(errorId);
        PMDPlugin.getDefault().showError(error, throwable);
    }
}

