/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.ui.IndexedString;
import net.sourceforge.pmd.eclipse.ui.Shape;
import net.sourceforge.pmd.eclipse.ui.preferences.br.FormatManager;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueFormatter;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.Configuration;
import net.sourceforge.pmd.eclipse.util.FontBuilder;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class RuleUIUtil {
    public static final Shape PriorityShape = Shape.diamond;
    public static final Shape RegexFilterShape = Shape.square;
    public static final Shape XPathFilterShape = Shape.circle;
    public static final FontBuilder blueBold11 = new FontBuilder("Tahoma", 11, 1, 9);
    public static final FontBuilder redBold11 = new FontBuilder("Tahoma", 11, 1, 3);
    public static final FontBuilder ChangedPropertyFont = blueBold11;
    public static final VerifyListener RuleNameVerifier = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            event.doit = false;
            char ch = event.character;
            String text = ((Text)event.widget).getText();
            if (Character.isDigit(ch) && text.length() == 0) {
                event.doit = false;
                return;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                event.doit = true;
            }
            if (ch == '\b') {
                event.doit = true;
            }
        }
    };
    public static final VerifyListener RuleLabelVerifier = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            event.doit = false;
            char ch = event.character;
            String text = ((Text)event.widget).getText();
            if (Character.isWhitespace(ch) && text.length() == 0) {
                event.doit = false;
                return;
            }
            event.doit = true;
        }
    };

    public static String ruleSetNameFrom(Rule rule) {
        return RuleUIUtil.ruleSetNameFrom(rule.getRuleSetName());
    }

    public static String ruleSetNameFrom(String rulesetName) {
        int pos = rulesetName.toUpperCase().indexOf("RULES");
        return pos < 0 ? rulesetName : rulesetName.substring(0, pos - 1);
    }

    private static int formatValueOn(StringBuilder target, Map.Entry<PropertyDescriptor<?>, Object> entry, String modifiedTag) {
        ValueFormatter formatter;
        boolean isModified;
        Object value = entry.getValue();
        Class datatype = entry.getKey().type();
        boolean bl = isModified = !RuleUtil.isDefaultValue(entry);
        if (isModified) {
            target.append(modifiedTag);
        }
        if ((formatter = FormatManager.formatterFor(datatype)) != null) {
            String output = formatter.format(value);
            target.append(output);
            return isModified ? output.length() : 0;
        }
        String out = String.valueOf(value);
        target.append(out);
        return isModified ? out.length() : 0;
    }

    public static String propertyStringFrom(Rule rule, String modifiedTag) {
        Map<PropertyDescriptor<?>, Object> valuesByProp = Configuration.filteredPropertiesOf((PropertySource)rule);
        if (valuesByProp.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(80);
        Iterator<Map.Entry<PropertyDescriptor<?>, Object>> iter = valuesByProp.entrySet().iterator();
        Map.Entry<PropertyDescriptor<?>, Object> entry = iter.next();
        sb.append(entry.getKey().name()).append(": ");
        RuleUIUtil.formatValueOn(sb, entry, modifiedTag);
        while (iter.hasNext()) {
            entry = iter.next();
            sb.append(", ").append(entry.getKey().name()).append(": ");
            RuleUIUtil.formatValueOn(sb, entry, modifiedTag);
        }
        return sb.toString();
    }

    public static IndexedString indexedPropertyStringFrom(Rule rule) {
        Map<PropertyDescriptor<?>, Object> valuesByProp = Configuration.filteredPropertiesOf((PropertySource)rule);
        if (valuesByProp.isEmpty()) {
            return IndexedString.Empty;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<PropertyDescriptor<?>, Object>> iter = valuesByProp.entrySet().iterator();
        ArrayList<int[]> modifiedValueIndexes = new ArrayList<int[]>(valuesByProp.size());
        Map.Entry<PropertyDescriptor<?>, Object> entry = iter.next();
        sb.append(entry.getKey().name()).append(": ");
        int start = sb.length();
        int stop = start + RuleUIUtil.formatValueOn(sb, entry, "");
        if (stop > start) {
            modifiedValueIndexes.add(new int[]{start, stop});
        }
        while (iter.hasNext()) {
            entry = iter.next();
            sb.append(", ").append(entry.getKey().name()).append(": ");
            start = sb.length();
            stop = start + RuleUIUtil.formatValueOn(sb, entry, "");
            if (stop <= start) continue;
            modifiedValueIndexes.add(new int[]{start, stop});
        }
        return new IndexedString(sb.toString(), modifiedValueIndexes);
    }
}

