/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleUtil;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class RuleDialog
extends Dialog {
    private static final int MODE_ADD = 1;
    private static final int MODE_EDIT = 2;
    private static final int MODE_VIEW = 3;
    protected Text implementationClassText;
    private int mode = 1;
    private Rule editedRule;
    private Rule rule;
    private Text ruleSetNameText;
    private Button ruleReferenceButton;
    private Text nameText;
    private Button xpathRuleButton;
    private Text messageText;
    private Combo priorityCombo;
    protected Button usesTypeResolutionButton;
    protected Button usesDfaButton;
    private Text descriptionText;
    private Text externalInfoUrlText;
    protected Button openExternalInfoUrlButton;
    private Text exampleText;
    protected Text xpathText;
    private Font courierFont;

    public RuleDialog(Shell parent) {
        super(parent);
        this.mode = 1;
    }

    public RuleDialog(Shell parent, Rule editedRule) {
        super(parent);
        this.mode = 2;
        this.editedRule = editedRule;
    }

    public RuleDialog(Shell parent, Rule editedRule, boolean flEdit) {
        super(parent);
        this.mode = flEdit ? 2 : 3;
        this.editedRule = editedRule;
    }

    protected Control createDialogArea(Composite parent) {
        this.courierFont = new Font((Device)this.getShell().getDisplay(), "Courier New", 10, 0);
        Composite dlgArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        dlgArea.setLayout((Layout)gridLayout);
        Label ruleSetNameLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.ruleset_name");
        GridData data = new GridData();
        data.horizontalSpan = 1;
        ruleSetNameLabel.setLayoutData((Object)data);
        this.ruleSetNameText = this.buildRuleSetNameText(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        this.ruleSetNameText.setLayoutData((Object)data);
        this.ruleReferenceButton = this.buildRuleReferenceButton(dlgArea);
        Label nameLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.name");
        data = new GridData();
        data.horizontalSpan = 4;
        nameLabel.setLayoutData((Object)data);
        this.nameText = this.buildNameText(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 3;
        data.grabExcessHorizontalSpace = true;
        this.nameText.setLayoutData((Object)data);
        this.xpathRuleButton = this.buildXPathRuleButton(dlgArea);
        Label implementationClassLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.implementation_class");
        data = new GridData();
        data.horizontalSpan = 4;
        implementationClassLabel.setLayoutData((Object)data);
        this.implementationClassText = this.buildImplementationClassText(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 4;
        data.grabExcessHorizontalSpace = true;
        this.implementationClassText.setLayoutData((Object)data);
        Label messageLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.message");
        data = new GridData();
        data.horizontalSpan = 4;
        messageLabel.setLayoutData((Object)data);
        this.messageText = this.buildMessageText(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 4;
        data.grabExcessHorizontalSpace = true;
        this.messageText.setLayoutData((Object)data);
        Label priorityLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.priority");
        data = new GridData();
        data.horizontalSpan = 1;
        priorityLabel.setLayoutData((Object)data);
        this.priorityCombo = this.buildPriorityCombo(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        this.priorityCombo.setLayoutData((Object)data);
        this.usesTypeResolutionButton = this.buildUsesTypeResolutionButton(dlgArea);
        this.usesDfaButton = this.buildUsesDfaButton(dlgArea);
        Label descriptionLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.description");
        data = new GridData();
        data.horizontalSpan = 4;
        descriptionLabel.setLayoutData((Object)data);
        this.descriptionText = this.buildDescriptionText(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.horizontalSpan = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.widthHint = 300;
        data.heightHint = 100;
        this.descriptionText.setLayoutData((Object)data);
        Label externalInfoUrlLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.external_info_url");
        data = new GridData();
        data.horizontalSpan = 3;
        externalInfoUrlLabel.setLayoutData((Object)data);
        this.openExternalInfoUrlButton = this.buildOpenExternalInfoUrlButton(dlgArea);
        this.externalInfoUrlText = this.buildExternalInfoUrlText(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 4;
        data.grabExcessHorizontalSpace = true;
        this.externalInfoUrlText.setLayoutData((Object)data);
        Label exampleLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.examples");
        data = new GridData();
        data.horizontalSpan = 4;
        exampleLabel.setLayoutData((Object)data);
        this.exampleText = this.buildExampleText(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.horizontalSpan = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.widthHint = 300;
        data.heightHint = 70;
        this.exampleText.setLayoutData((Object)data);
        Label xpathLabel = this.buildLabel(dlgArea, "preference.ruleedit.label.xpath");
        data = new GridData();
        data.horizontalSpan = 4;
        xpathLabel.setLayoutData((Object)data);
        this.xpathText = this.buildXPathText(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.horizontalSpan = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.widthHint = 300;
        data.heightHint = 100;
        this.xpathText.setLayoutData((Object)data);
        this.getShell().setText(this.getMessage("preference.ruleset.dialog.title"));
        this.refreshOverridden();
        return dlgArea;
    }

    private Label buildLabel(Composite parent, String msgKey) {
        Label label = new Label(parent, 0);
        label.setText(msgKey == null ? "" : this.getMessage(msgKey));
        return label;
    }

    private Text buildRuleSetNameText(Composite parent) {
        Text text = new Text(parent, 2052);
        if (this.mode == 1) {
            text.setText("pmd-eclipse");
            text.setEnabled(false);
        }
        if (this.mode == 2) {
            text.setText(this.editedRule.getRuleSetName());
            text.setEnabled(false);
        }
        if (this.mode == 3) {
            text.setText(this.editedRule.getRuleSetName());
            text.setEnabled(false);
        }
        return text;
    }

    private Button buildRuleReferenceButton(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText(this.getMessage("preference.ruleedit.button.rule_reference"));
        button.setEnabled(false);
        button.setSelection(this.editedRule instanceof RuleReference);
        return button;
    }

    private Text buildNameText(Composite parent) {
        Text text = new Text(parent, 2052);
        if (this.mode == 1) {
            text.setFocus();
        }
        if (this.mode == 2) {
            text.setText(this.editedRule.getName());
            text.setEnabled(false);
        }
        if (this.mode == 3) {
            text.setEditable(false);
            text.setText(this.editedRule.getName());
        }
        return text;
    }

    private Button buildXPathRuleButton(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText(this.getMessage("preference.ruleedit.button.xpath_rule"));
        if (this.mode == 3) {
            button.setVisible(false);
        } else {
            if (this.mode == 2) {
                button.setSelection(this.editedRule.getRuleClass().endsWith("XPathRule"));
                button.setEnabled(false);
            } else {
                button.setEnabled(true);
                button.setSelection(true);
            }
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (button.getSelection()) {
                        RuleDialog.this.implementationClassText.setText(XPathRule.class.getName());
                        RuleDialog.this.implementationClassText.setEnabled(false);
                        RuleDialog.this.xpathText.setEnabled(true);
                        RuleDialog.this.usesTypeResolutionButton.setEnabled(false);
                        RuleDialog.this.usesTypeResolutionButton.setSelection(true);
                        RuleDialog.this.usesDfaButton.setEnabled(false);
                        RuleDialog.this.usesDfaButton.setSelection(false);
                    } else {
                        RuleDialog.this.implementationClassText.setText("");
                        RuleDialog.this.implementationClassText.setEnabled(true);
                        RuleDialog.this.xpathText.setText("");
                        RuleDialog.this.xpathText.setEnabled(false);
                        RuleDialog.this.usesTypeResolutionButton.setEnabled(true);
                        RuleDialog.this.usesTypeResolutionButton.setSelection(true);
                        RuleDialog.this.usesDfaButton.setEnabled(true);
                        RuleDialog.this.usesDfaButton.setSelection(false);
                    }
                }
            });
        }
        return button;
    }

    private Text buildImplementationClassText(Composite parent) {
        Text text = new Text(parent, 2052);
        if (this.mode == 2) {
            text.setText(this.editedRule.getRuleClass());
            text.setEnabled(false);
        }
        if (this.mode == 3) {
            text.setEditable(false);
            text.setText(this.editedRule.getRuleClass());
        }
        if (this.mode == 1) {
            text.setText(XPathRule.class.getName());
            text.setEnabled(false);
        }
        return text;
    }

    private Text buildMessageText(Composite parent) {
        Text text = new Text(parent, 2052);
        if (this.mode == 2) {
            text.setFocus();
            text.setText(this.editedRule.getMessage().trim());
        }
        if (this.mode == 3) {
            text.setEditable(false);
            text.setText(this.editedRule.getMessage().trim());
        }
        return text;
    }

    private Combo buildPriorityCombo(Composite parent) {
        Combo combo = new Combo(parent, 2048);
        String[] labels = UISettings.getPriorityLabels();
        int index = 2;
        if (this.editedRule != null && this.editedRule.getPriority().getPriority() >= 0 && this.editedRule.getPriority().getPriority() <= labels.length) {
            index = this.editedRule.getPriority().getPriority() - 1;
        }
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            combo.add(label);
            ++n2;
        }
        combo.select(index);
        if (this.mode == 3) {
            combo.setEnabled(false);
        } else if (this.mode == 2) {
            combo.setEnabled(true);
        } else if (this.mode == 1) {
            combo.setEnabled(true);
        }
        return combo;
    }

    private Button buildUsesTypeResolutionButton(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText(this.getMessage("preference.ruleedit.button.uses_type_resolution"));
        if (this.mode == 3) {
            button.setVisible(false);
        } else if (this.mode == 2) {
            button.setEnabled(false);
            button.setSelection(this.editedRule.usesTypeResolution());
        } else {
            button.setEnabled(false);
            button.setSelection(true);
        }
        return button;
    }

    private Button buildUsesDfaButton(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText(this.getMessage("preference.ruleedit.button.uses_dfa"));
        if (this.mode == 3) {
            button.setVisible(false);
        } else if (this.mode == 2) {
            button.setEnabled(false);
            button.setSelection(this.editedRule.usesDFA());
        } else {
            button.setEnabled(false);
            button.setSelection(false);
        }
        return button;
    }

    private Text buildDescriptionText(Composite parent) {
        Text text = new Text(parent, 2626);
        String description = null;
        if (this.editedRule != null) {
            description = this.editedRule.getDescription();
        }
        if (description == null) {
            description = "";
        }
        text.setText(description.trim());
        if (this.mode == 3) {
            text.setEditable(false);
        }
        return text;
    }

    private Text buildExternalInfoUrlText(Composite parent) {
        Text text = new Text(parent, 2052);
        String externalInfoUrl = null;
        if (this.editedRule != null) {
            externalInfoUrl = this.editedRule.getExternalInfoUrl();
        }
        if (externalInfoUrl == null) {
            externalInfoUrl = "";
        }
        text.setText(externalInfoUrl.trim());
        if (this.mode == 3) {
            text.setEditable(false);
        }
        return text;
    }

    private Button buildOpenExternalInfoUrlButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(this.getMessage("preference.ruleedit.button.open_external_info_url"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String url = RuleDialog.this.externalInfoUrlText.getText().trim();
                if (url.length() > 0) {
                    try {
                        IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                        browser.openURL(new URL(url));
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        return button;
    }

    private String getExamplesString() {
        StringBuffer buffer = new StringBuffer();
        Iterator i = this.editedRule.getExamples().iterator();
        boolean first = true;
        while (i.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append("\n\n");
            }
            buffer.append(((String)i.next()).trim());
        }
        return buffer.toString();
    }

    private Text buildExampleText(Composite parent) {
        Text text = new Text(parent, 2818);
        text.setFont(this.courierFont);
        if (this.mode == 2) {
            text.setText(this.getExamplesString());
        }
        if (this.mode == 3) {
            text.setEditable(false);
            text.setText(this.getExamplesString());
        }
        return text;
    }

    private Text buildXPathText(Composite parent) {
        Text text = new Text(parent, 2818);
        text.setFont(this.courierFont);
        if (this.mode == 1) {
            text.setEditable(true);
            text.setEnabled(true);
        }
        if (this.mode == 2 && RuleUtil.isXPathRule((PropertySource)this.editedRule)) {
            text.setText(((String)this.editedRule.getProperty((PropertyDescriptor)XPathRule.XPATH_DESCRIPTOR)).trim());
            text.setEditable(true);
        }
        if (this.mode == 3) {
            text.setEditable(false);
            if (RuleUtil.isXPathRule((PropertySource)this.editedRule)) {
                text.setText(((String)this.editedRule.getProperty((PropertyDescriptor)XPathRule.XPATH_DESCRIPTOR)).trim());
            }
        }
        return text;
    }

    protected void refreshOverridden() {
        if ((this.mode == 2 || this.mode == 3) && this.editedRule instanceof RuleReference) {
            RuleReference ruleReference = (RuleReference)this.editedRule;
            Color lightBlue = new Color(null, 196, 196, 255);
            this.nameText.setBackground((Color)(ruleReference.getOverriddenName() != null ? lightBlue : null));
            this.messageText.setBackground((Color)(ruleReference.getOverriddenMessage() != null ? lightBlue : null));
            this.priorityCombo.setBackground((Color)(ruleReference.getOverriddenPriority() != null ? lightBlue : null));
            this.descriptionText.setBackground((Color)(ruleReference.getOverriddenDescription() != null ? lightBlue : null));
            this.externalInfoUrlText.setBackground((Color)(ruleReference.getOverriddenExternalInfoUrl() != null ? lightBlue : null));
            this.exampleText.setBackground((Color)(ruleReference.getOverriddenExamples() != null ? lightBlue : null));
            this.xpathText.setBackground((Color)(ruleReference.hasOverriddenProperty((PropertyDescriptor)XPathRule.XPATH_DESCRIPTOR) ? lightBlue : null));
        }
    }

    private String getMessage(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }

    protected void okPressed() {
        if (this.validateForm() && this.mode != 3) {
            super.okPressed();
        } else if (this.mode == 3) {
            this.cancelPressed();
        }
    }

    private boolean validateForm() {
        return this.validateName() && this.validatePriority() && this.validateMessage() && this.validateImplementationClass();
    }

    private boolean validateName() {
        boolean flValid = true;
        String name = this.nameText.getText();
        if (StringUtil.isEmpty((String)name)) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getMessage("message.warning.title"), (String)this.getMessage("message.warning.name_mandatory"));
            this.nameText.setFocus();
            flValid = false;
        }
        return flValid;
    }

    private boolean validatePriority() {
        boolean flValid = true;
        if (this.priorityCombo.getSelectionIndex() < 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getMessage("message.warning.title"), (String)this.getMessage("message.warning.priority_mandatory"));
            this.priorityCombo.setFocus();
            flValid = false;
        }
        return flValid;
    }

    private boolean validateMessage() {
        boolean flValid = true;
        String message = this.messageText.getText();
        if (StringUtil.isEmpty((String)message)) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getMessage("message.warning.title"), (String)this.getMessage("message.warning.message_mandatory"));
            this.messageText.setFocus();
            flValid = false;
        }
        return flValid;
    }

    private boolean validateImplementationClass() {
        boolean flClassError;
        boolean flValid;
        block14: {
            flValid = true;
            flClassError = false;
            if (this.mode == 1) {
                try {
                    Class<?> ruleClass = Class.forName(this.implementationClassText.getText());
                    Object instance = ruleClass.newInstance();
                    if (instance instanceof Rule) {
                        this.rule = (Rule)ruleClass.newInstance();
                        this.rule.setName(this.nameText.getText().trim());
                        this.rule.setRuleSetName("pmd-eclipse");
                        this.rule.setMessage(this.messageText.getText().trim());
                        this.rule.setDescription(this.descriptionText.getText());
                        this.rule.getExamples().add(this.exampleText.getText());
                        this.rule.setPriority(RulePriority.valueOf((int)(this.priorityCombo.getSelectionIndex() + 1)));
                        this.rule.setExternalInfoUrl(this.externalInfoUrlText.getText());
                        if (this.usesTypeResolutionButton.getSelection()) {
                            this.rule.setUsesTypeResolution();
                        }
                        if (this.usesDfaButton.getSelection()) {
                            this.rule.setUsesDFA();
                        }
                        if (this.rule instanceof XPathRule) {
                            String xpath = this.xpathText.getText().trim();
                            if (xpath.length() != 0) {
                                this.rule.setProperty((PropertyDescriptor)XPathRule.XPATH_DESCRIPTOR, (Object)xpath);
                            } else {
                                MessageDialog.openWarning((Shell)this.getShell(), (String)this.getMessage("message.warning.title"), (String)this.getMessage("message.warning.xpath_mandatory"));
                                this.xpathText.setFocus();
                                flValid = false;
                            }
                        }
                        break block14;
                    }
                    flClassError = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    flClassError = true;
                }
                catch (InstantiationException instantiationException) {
                    flClassError = true;
                }
                catch (IllegalAccessException illegalAccessException) {
                    flClassError = true;
                }
            } else {
                this.editedRule.setMessage(this.messageText.getText().trim());
                this.editedRule.setPriority(RulePriority.valueOf((int)(this.priorityCombo.getSelectionIndex() + 1)));
                this.editedRule.setDescription(this.descriptionText.getText());
                this.editedRule.setExternalInfoUrl(this.externalInfoUrlText.getText());
                this.editedRule.addExample(this.exampleText.getText());
                String xpath = this.xpathText.getText().trim();
                if (xpath.length() > 0) {
                    this.editedRule.setProperty((PropertyDescriptor)XPathRule.XPATH_DESCRIPTOR, (Object)xpath);
                }
            }
        }
        if (flClassError) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getMessage("message.warning.title"), (String)this.getMessage("message.warning.class_invalid"));
            this.implementationClassText.setFocus();
            flValid = false;
        }
        return flValid;
    }

    public Rule getRule() {
        return this.rule;
    }

    protected void cancelPressed() {
        this.courierFont.dispose();
        super.cancelPressed();
    }
}

