/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.namespaces.INamespaceDefinition;
import org.springframework.ide.eclipse.beans.ui.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.core.SpringCorePreferences;
import org.springframework.ide.eclipse.ui.dialogs.ProjectAndPreferencePage;
import org.springframework.util.StringUtils;

public class NamespaceVersionPreferencePage
extends ProjectAndPreferencePage {
    public static final String PREF_ID = "org.springframework.ide.eclipse.beans.ui.namespaces.preferencePage";
    public static final String PROP_ID = "org.springframework.ide.eclipse.beans.ui.namespaces.projectPropertyPage";
    private static final int XSD_LIST_VIEWER_HEIGHT = 150;
    private static final int LIST_VIEWER_WIDTH = 340;
    private TableViewer xsdViewer;
    private CheckboxTableViewer versionViewer;
    private Button versionCheckbox;
    private Button classpathCheckbox;
    private Button disableNamespaceCachingCheckbox;
    private Map<INamespaceDefinition, String> versions = new ConcurrentHashMap<INamespaceDefinition, String>();
    private Map<INamespaceDefinition, String> prefixes = new ConcurrentHashMap<INamespaceDefinition, String>();
    private INamespaceDefinition selectedNamespaceDefinition;
    private Text prefixText;
    private volatile List<INamespaceDefinition> namespaceDefinitionList = new CopyOnWriteArrayList<INamespaceDefinition>();
    private volatile boolean loading = false;

    private synchronized List<INamespaceDefinition> getNamespaceDefinitionList() {
        if (!(this.namespaceDefinitionList != null && this.namespaceDefinitionList.size() != 0 || this.loading)) {
            this.loading = true;
            NamespaceUtils.getNamespaceDefinitions(this.getProject(), new NamespaceUtils.INamespaceDefinitionTemplate(){

                @Override
                public void doWithNamespaceDefinitions(INamespaceDefinition[] namespaceDefinitions, IProject project) {
                    NamespaceVersionPreferencePage.this.namespaceDefinitionList = new ArrayList<INamespaceDefinition>(Arrays.asList(namespaceDefinitions));
                    NamespaceVersionPreferencePage.this.versions.clear();
                    NamespaceVersionPreferencePage.this.prefixes.clear();
                    if (NamespaceVersionPreferencePage.this.isProjectPreferencePage()) {
                        SpringCorePreferences prefs = SpringCorePreferences.getProjectPreferences((IProject)NamespaceVersionPreferencePage.this.getProject(), (String)"org.springframework.ide.eclipse.beans.core");
                        INamespaceDefinition[] iNamespaceDefinitionArray = namespaceDefinitions;
                        int n = namespaceDefinitions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            INamespaceDefinition namespace = iNamespaceDefinitionArray[n2];
                            String version = prefs.getString("default.version." + namespace.getNamespaceURI(), "");
                            NamespaceVersionPreferencePage.this.versions.put(namespace, version);
                            String prefix = prefs.getString("prefix." + namespace.getNamespaceURI(), namespace.getDefaultNamespacePrefix());
                            NamespaceVersionPreferencePage.this.prefixes.put(namespace, prefix);
                            ++n2;
                        }
                    } else {
                        Preferences prefs = BeansCorePlugin.getDefault().getPluginPreferences();
                        INamespaceDefinition[] iNamespaceDefinitionArray = namespaceDefinitions;
                        int n = namespaceDefinitions.length;
                        int n3 = 0;
                        while (n3 < n) {
                            INamespaceDefinition namespace = iNamespaceDefinitionArray[n3];
                            String version = prefs.getString("default.version." + namespace.getNamespaceURI());
                            NamespaceVersionPreferencePage.this.versions.put(namespace, version);
                            String prefix = prefs.getString("prefix." + namespace.getNamespaceURI());
                            NamespaceVersionPreferencePage.this.prefixes.put(namespace, StringUtils.hasLength((String)prefix) ? prefix : namespace.getDefaultNamespacePrefix());
                            ++n3;
                        }
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            NamespaceVersionPreferencePage.this.refresh();
                        }
                    });
                    NamespaceVersionPreferencePage.this.loading = false;
                }
            });
        }
        return this.namespaceDefinitionList;
    }

    public Composite createPreferenceContent(Composite parent) {
        Preferences prefs;
        boolean versionClasspath = true;
        boolean useClasspath = true;
        boolean disableCachingNamespaces = false;
        if (this.isProjectPreferencePage()) {
            prefs = SpringCorePreferences.getProjectPreferences((IProject)this.getProject(), (String)"org.springframework.ide.eclipse.beans.core");
            versionClasspath = prefs.getBoolean("default.version.check.classpath", true);
            useClasspath = prefs.getBoolean("loadNamespaceHandlerFromClasspath", true);
            disableCachingNamespaces = prefs.getBoolean("disableCachingForNamespaceLoadingFromClasspath", false);
        } else {
            prefs = BeansCorePlugin.getDefault().getPluginPreferences();
            versionClasspath = prefs.getBoolean("default.version.check.classpath");
            useClasspath = prefs.getBoolean("loadNamespaceHandlerFromClasspath");
            disableCachingNamespaces = prefs.getBoolean("disableCachingForNamespaceLoadingFromClasspath");
        }
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.versionCheckbox = new Button(composite, 32);
        this.versionCheckbox.setText("Use highest XSD version that is available on the project's classpath");
        this.versionCheckbox.setSelection(versionClasspath);
        this.classpathCheckbox = new Button(composite, 32);
        this.classpathCheckbox.setText("Load NamespaceHandlers and XSDs from project's classpath");
        this.classpathCheckbox.setSelection(useClasspath);
        this.classpathCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NamespaceVersionPreferencePage.this.isProjectPreferencePage()) {
                    if (NamespaceVersionPreferencePage.this.useProjectSettings()) {
                        SpringCorePreferences.getProjectPreferences((IProject)NamespaceVersionPreferencePage.this.getProject(), (String)"org.springframework.ide.eclipse.beans.core").putBoolean("enable.project.preferences", true);
                    } else {
                        SpringCorePreferences.getProjectPreferences((IProject)NamespaceVersionPreferencePage.this.getProject(), (String)"org.springframework.ide.eclipse.beans.core").putBoolean("enable.project.preferences", false);
                    }
                    SpringCorePreferences.getProjectPreferences((IProject)NamespaceVersionPreferencePage.this.getProject(), (String)"org.springframework.ide.eclipse.beans.core").putBoolean("loadNamespaceHandlerFromClasspath", NamespaceVersionPreferencePage.this.classpathCheckbox.getSelection());
                } else {
                    BeansCorePlugin.getDefault().getPluginPreferences().setValue("loadNamespaceHandlerFromClasspath", NamespaceVersionPreferencePage.this.classpathCheckbox.getSelection());
                    BeansCorePlugin.getDefault().savePluginPreferences();
                }
                NamespaceVersionPreferencePage.this.namespaceDefinitionList.clear();
                NamespaceVersionPreferencePage.this.refresh();
                NamespaceVersionPreferencePage.this.disableNamespaceCachingCheckbox.setEnabled(NamespaceVersionPreferencePage.this.classpathCheckbox.getSelection());
            }
        });
        this.disableNamespaceCachingCheckbox = new Button(composite, 32);
        this.disableNamespaceCachingCheckbox.setText("Disable caching for namespace resolving and loading");
        this.disableNamespaceCachingCheckbox.setSelection(disableCachingNamespaces);
        this.disableNamespaceCachingCheckbox.setEnabled(useClasspath);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = 15;
        this.disableNamespaceCachingCheckbox.setLayoutData((Object)data);
        this.disableNamespaceCachingCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NamespaceVersionPreferencePage.this.isProjectPreferencePage()) {
                    SpringCorePreferences.getProjectPreferences((IProject)NamespaceVersionPreferencePage.this.getProject(), (String)"org.springframework.ide.eclipse.beans.core").putBoolean("disableCachingForNamespaceLoadingFromClasspath", NamespaceVersionPreferencePage.this.disableNamespaceCachingCheckbox.getSelection());
                } else {
                    BeansCorePlugin.getDefault().getPluginPreferences().setValue("disableCachingForNamespaceLoadingFromClasspath", NamespaceVersionPreferencePage.this.disableNamespaceCachingCheckbox.getSelection());
                    BeansCorePlugin.getDefault().savePluginPreferences();
                }
            }
        });
        Label namespaceLabel = new Label(composite, 0);
        namespaceLabel.setText("Select XSD namespace to configure prefix and default version:");
        GridData gd = new GridData(1808);
        gd.widthHint = 340;
        gd.heightHint = 150;
        this.xsdViewer = new TableViewer(composite, 2048);
        this.xsdViewer.getTable().setLayoutData((Object)gd);
        this.xsdViewer.setContentProvider((IContentProvider)new XsdConfigContentProvider());
        this.xsdViewer.setLabelProvider((IBaseLabelProvider)new XsdLabelProvider());
        this.xsdViewer.setInput((Object)this);
        this.xsdViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                if (event.getSelection() instanceof IStructuredSelection && (obj = ((IStructuredSelection)event.getSelection()).getFirstElement()) != null) {
                    NamespaceVersionPreferencePage.this.selectedNamespaceDefinition = (INamespaceDefinition)obj;
                    NamespaceVersionPreferencePage.this.versionViewer.setInput(obj);
                    NamespaceVersionPreferencePage.this.prefixText.setText((String)NamespaceVersionPreferencePage.this.prefixes.get(NamespaceVersionPreferencePage.this.selectedNamespaceDefinition));
                    if (NamespaceVersionPreferencePage.this.versions.get(NamespaceVersionPreferencePage.this.selectedNamespaceDefinition) != null) {
                        NamespaceVersionPreferencePage.this.versionViewer.setCheckedElements(new Object[]{NamespaceVersionPreferencePage.this.versions.get(NamespaceVersionPreferencePage.this.selectedNamespaceDefinition)});
                    }
                    if (NamespaceVersionPreferencePage.this.selectedNamespaceDefinition.getSchemaLocations().size() > 0) {
                        NamespaceVersionPreferencePage.this.versionViewer.getControl().setEnabled(true);
                    } else {
                        NamespaceVersionPreferencePage.this.versionViewer.getControl().setEnabled(false);
                    }
                }
            }
        });
        new Label(composite, 131072);
        Composite prefixComposite = new Composite(composite, 0);
        GridLayout prefixLayout = new GridLayout();
        prefixLayout.numColumns = 2;
        prefixLayout.marginWidth = 0;
        prefixLayout.marginHeight = 0;
        prefixComposite.setLayout((Layout)prefixLayout);
        prefixComposite.setLayoutData((Object)new GridData(272));
        prefixComposite.setFont(parent.getFont());
        Label prefixLabel = new Label(prefixComposite, 0);
        prefixLabel.setText("Namespace prefix:");
        this.prefixText = new Text(prefixComposite, 2048);
        this.prefixText.setLayoutData((Object)new GridData(768));
        this.prefixText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean valid = true;
                for (Map.Entry entry : NamespaceVersionPreferencePage.this.prefixes.entrySet()) {
                    if (((INamespaceDefinition)entry.getKey()).equals(NamespaceVersionPreferencePage.this.selectedNamespaceDefinition) || !((String)entry.getValue()).equals(NamespaceVersionPreferencePage.this.prefixText.getText())) continue;
                    NamespaceVersionPreferencePage.this.setErrorMessage(String.format("Prefix '%s' not unique", entry.getValue()));
                    valid = false;
                }
                NamespaceVersionPreferencePage.this.setValid(valid);
                if (valid) {
                    NamespaceVersionPreferencePage.this.setErrorMessage(null);
                }
                if (StringUtils.hasLength((String)NamespaceVersionPreferencePage.this.prefixText.getText())) {
                    NamespaceVersionPreferencePage.this.prefixes.put(NamespaceVersionPreferencePage.this.selectedNamespaceDefinition, NamespaceVersionPreferencePage.this.prefixText.getText());
                } else {
                    NamespaceVersionPreferencePage.this.prefixes.put(NamespaceVersionPreferencePage.this.selectedNamespaceDefinition, NamespaceVersionPreferencePage.this.selectedNamespaceDefinition.getDefaultNamespacePrefix());
                }
                NamespaceVersionPreferencePage.this.xsdViewer.setInput((Object)this);
            }
        });
        Label versionLabel = new Label(composite, 0);
        versionLabel.setText("Select default schema version (if none is selected the versionless schema will be used):");
        this.versionViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.versionViewer.getTable().setLayoutData((Object)gd);
        this.versionViewer.setContentProvider((IContentProvider)new VersionContentProvider());
        this.versionViewer.setLabelProvider((IBaseLabelProvider)new VersionLabelProvider());
        this.versionViewer.setSorter(new ViewerSorter());
        this.versionViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    NamespaceVersionPreferencePage.this.versionViewer.setCheckedElements(new Object[]{event.getElement()});
                    if (NamespaceVersionPreferencePage.this.selectedNamespaceDefinition != null) {
                        NamespaceVersionPreferencePage.this.versions.put(NamespaceVersionPreferencePage.this.selectedNamespaceDefinition, (String)event.getElement());
                    }
                } else {
                    NamespaceVersionPreferencePage.this.versionViewer.setCheckedElements(new Object[0]);
                    NamespaceVersionPreferencePage.this.versions.put(NamespaceVersionPreferencePage.this.selectedNamespaceDefinition, "");
                }
            }
        });
        return composite;
    }

    protected String getPreferencePageID() {
        return PREF_ID;
    }

    protected String getPropertyPageID() {
        return PROP_ID;
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        return SpringCorePreferences.getProjectPreferences((IProject)project, (String)"org.springframework.ide.eclipse.beans.core").getBoolean("enable.project.preferences", false);
    }

    public boolean performOk() {
        if (this.isProjectPreferencePage()) {
            if (this.useProjectSettings()) {
                SpringCorePreferences.getProjectPreferences((IProject)this.getProject(), (String)"org.springframework.ide.eclipse.beans.core").putBoolean("enable.project.preferences", true);
            } else {
                SpringCorePreferences.getProjectPreferences((IProject)this.getProject(), (String)"org.springframework.ide.eclipse.beans.core").putBoolean("enable.project.preferences", false);
            }
            for (Map.Entry<INamespaceDefinition, String> entry : this.versions.entrySet()) {
                SpringCorePreferences.getProjectPreferences((IProject)this.getProject(), (String)"org.springframework.ide.eclipse.beans.core").putString("default.version." + entry.getKey().getNamespaceURI(), entry.getValue());
            }
            for (Map.Entry<INamespaceDefinition, String> entry : this.prefixes.entrySet()) {
                SpringCorePreferences.getProjectPreferences((IProject)this.getProject(), (String)"org.springframework.ide.eclipse.beans.core").putString("prefix." + entry.getKey().getNamespaceURI(), entry.getValue());
            }
            SpringCorePreferences.getProjectPreferences((IProject)this.getProject(), (String)"org.springframework.ide.eclipse.beans.core").putBoolean("default.version.check.classpath", this.versionCheckbox.getSelection());
            SpringCorePreferences.getProjectPreferences((IProject)this.getProject(), (String)"org.springframework.ide.eclipse.beans.core").putBoolean("loadNamespaceHandlerFromClasspath", this.classpathCheckbox.getSelection());
        } else {
            for (Map.Entry<INamespaceDefinition, String> entry : this.versions.entrySet()) {
                BeansCorePlugin.getDefault().getPluginPreferences().setValue("default.version." + entry.getKey().getNamespaceURI(), entry.getValue());
            }
            for (Map.Entry<INamespaceDefinition, String> entry : this.prefixes.entrySet()) {
                BeansCorePlugin.getDefault().getPluginPreferences().setValue("prefix." + entry.getKey().getNamespaceURI(), entry.getValue());
            }
            BeansCorePlugin.getDefault().getPluginPreferences().setValue("default.version.check.classpath", this.versionCheckbox.getSelection());
            BeansCorePlugin.getDefault().getPluginPreferences().setValue("loadNamespaceHandlerFromClasspath", this.classpathCheckbox.getSelection());
            BeansCorePlugin.getDefault().savePluginPreferences();
        }
        BeansCorePlugin.notifyNamespaceDefinitionListeners(null);
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        for (Map.Entry<INamespaceDefinition, String> entry : this.versions.entrySet()) {
            entry.setValue("");
        }
        for (Map.Entry<INamespaceDefinition, String> entry : this.prefixes.entrySet()) {
            this.prefixes.put(entry.getKey(), entry.getKey().getDefaultNamespacePrefix());
        }
        this.xsdViewer.setInput((Object)this);
    }

    private void refresh() {
        if (this.xsdViewer != null && this.xsdViewer.getControl() != null && !this.xsdViewer.getControl().isDisposed()) {
            this.xsdViewer.setInput((Object)this);
        }
    }

    private class VersionContentProvider
    implements IStructuredContentProvider {
        private VersionContentProvider() {
        }

        public Object[] getElements(Object obj) {
            if (obj instanceof INamespaceDefinition) {
                return ((INamespaceDefinition)obj).getSchemaLocations().toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    public class VersionLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.xsd_obj.gif");
        }

        public String getText(Object element) {
            if (element instanceof String) {
                String label = (String)element;
                return label;
            }
            return super.getText(element);
        }
    }

    private class XsdConfigContentProvider
    implements IStructuredContentProvider {
        private XsdConfigContentProvider() {
        }

        public Object[] getElements(Object obj) {
            return NamespaceVersionPreferencePage.this.getNamespaceDefinitionList().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    public class XsdLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof INamespaceDefinition) {
                INamespaceDefinition xsdDef = (INamespaceDefinition)element;
                return xsdDef.getNamespaceImage();
            }
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.xsd_obj.gif");
        }

        public String getText(Object element) {
            if (element instanceof INamespaceDefinition) {
                INamespaceDefinition xsdDef = (INamespaceDefinition)element;
                return String.valueOf((String)NamespaceVersionPreferencePage.this.prefixes.get(xsdDef)) + " - " + xsdDef.getNamespaceURI();
            }
            return "";
        }
    }
}

