/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.boot;

import java.util.ArrayList;
import java.util.List;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.HierarchicalMultiSelectionFieldModel;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.MultiSelectionFieldModel;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.RadioGroup;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.RadioInfo;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.SimpleUriBuilder;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.json.IdAble;
import org.springsource.ide.eclipse.commons.livexp.core.FieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;

public class UrlMaker
extends LiveExpression<String> {
    private final List<FieldModel<String>> inputs = new ArrayList<FieldModel<String>>();
    private final List<MultiSelectionFieldModel<IdAble>> multiInputs = new ArrayList<MultiSelectionFieldModel<IdAble>>();
    private final List<FieldModel<RadioInfo>> radioInputs = new ArrayList<FieldModel<RadioInfo>>();
    private final LiveExpression<String> baseUrl;

    public UrlMaker(String baseUrl) {
        this((LiveExpression<String>)LiveExpression.constant((Object)baseUrl));
    }

    public UrlMaker(LiveExpression<String> baseUrl) {
        this.baseUrl = baseUrl;
        this.dependsOn(baseUrl);
    }

    public UrlMaker addField(FieldModel<String> param) {
        this.inputs.add(param);
        this.dependsOn((LiveExpression)param.getVariable());
        return this;
    }

    public UrlMaker addField(MultiSelectionFieldModel<? extends IdAble> param) {
        this.multiInputs.add(param);
        this.dependsOn((LiveExpression)param.getSelecteds());
        return this;
    }

    public void addField(HierarchicalMultiSelectionFieldModel<? extends IdAble> param) {
        for (String cat : param.getCategories()) {
            this.addField(param.getContents(cat));
        }
    }

    public UrlMaker addField(RadioGroup group) {
        this.radioInputs.add(group);
        this.dependsOn((LiveExpression)group.getVariable());
        return this;
    }

    protected String compute() {
        String baseUrl = (String)this.baseUrl.getValue();
        baseUrl = baseUrl == null ? "" : baseUrl.trim();
        SimpleUriBuilder builder = new SimpleUriBuilder(baseUrl);
        for (FieldModel<String> fieldModel : this.inputs) {
            String paramValue = (String)fieldModel.getValue();
            if (paramValue == null) continue;
            builder.addParameter(fieldModel.getName(), paramValue);
        }
        for (FieldModel fieldModel : this.radioInputs) {
            String paramValue;
            RadioInfo radio = (RadioInfo)fieldModel.getValue();
            if (radio == null || (paramValue = radio.getValue()) == null) continue;
            builder.addParameter(fieldModel.getName(), paramValue);
        }
        for (MultiSelectionFieldModel multiSelectionFieldModel : this.multiInputs) {
            String name = multiSelectionFieldModel.getName();
            for (IdAble selectedValue : multiSelectionFieldModel.getSelecteds().getValues()) {
                if (!((Boolean)multiSelectionFieldModel.getEnablement(selectedValue).getValue()).booleanValue()) continue;
                builder.addParameter(name, selectedValue.getId());
            }
        }
        return builder.toString();
    }
}

