/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.views;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.MergeResult;
import com.collabnet.subversion.merge.MergeResultsFolder;
import com.collabnet.subversion.merge.views.MergeResultsView;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class MergeResultsViewContentProvider
extends WorkbenchContentProvider {
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof MergeOutput || element instanceof MergeResultsFolder;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        MergeResultsFolder folder;
        int mode = this.store.getInt("MergeResultsView_layout");
        boolean conflictsOnly = this.store.getBoolean("MergeResultsView_conflictsOnly");
        if (parentElement instanceof MergeResultsView) {
            return MergeOutput.getMergeOutputs();
        }
        if (parentElement instanceof MergeOutput) {
            MergeOutput mergeOutput = (MergeOutput)parentElement;
            if (mode == 1) {
                if (conflictsOnly) {
                    return mergeOutput.getConflictedMergeResults();
                }
                return mergeOutput.getMergeResults();
            }
            if (mode == 0) {
                MergeResult[] rootMergeResults = mergeOutput.getRootMergeResults(conflictsOnly);
                MergeResultsFolder[] mergeResultFolders = mergeOutput.getCompressedFolders(conflictsOnly);
                ArrayList<Object> returnObjects = new ArrayList<Object>();
                int i = 0;
                while (i < mergeResultFolders.length) {
                    returnObjects.add(mergeResultFolders[i]);
                    ++i;
                }
                i = 0;
                while (i < rootMergeResults.length) {
                    returnObjects.add(rootMergeResults[i]);
                    ++i;
                }
                Object[] returnArray = new Object[returnObjects.size()];
                returnObjects.toArray(returnArray);
                return returnArray;
            }
        }
        if (parentElement instanceof MergeResultsFolder && (folder = (MergeResultsFolder)parentElement).isCompressed()) {
            return folder.getMergeResults(conflictsOnly);
        }
        return new Object[0];
    }
}

