/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.crucible.api.model;

import com.atlassian.connector.commons.misc.IntRanges;
import com.atlassian.theplugin.commons.crucible.api.model.Comment;
import com.atlassian.theplugin.commons.crucible.api.model.CrucibleFileInfo;
import com.atlassian.theplugin.commons.crucible.api.model.GeneralComment;
import com.atlassian.theplugin.commons.crucible.api.model.PermId;
import com.atlassian.theplugin.commons.crucible.api.model.Review;
import com.atlassian.theplugin.commons.util.MiscUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionedComment
extends Comment {
    private PermId reviewItemId;
    private int fromStartLine;
    private int fromEndLine;
    private boolean fromLineInfo;
    private int toStartLine;
    private int toEndLine;
    private boolean toLineInfo;
    private IntRanges toLineRanges;
    private IntRanges fromLineRanges;
    private Map<String, IntRanges> lineRanges;
    @NotNull
    private final CrucibleFileInfo crucibleFileInfo;
    private static final int HASH_INT = 31;

    public VersionedComment(VersionedComment bean) {
        super(bean);
        if (bean.isFromLineInfo()) {
            this.setFromLineInfo(true);
            this.setFromStartLine(bean.getFromStartLine());
            this.setFromEndLine(bean.getFromEndLine());
        }
        if (bean.isToLineInfo()) {
            this.setToLineInfo(true);
            this.setToStartLine(bean.getToStartLine());
            this.setToEndLine(bean.getToEndLine());
        }
        this.crucibleFileInfo = bean.crucibleFileInfo;
    }

    public VersionedComment(Review review, @NotNull CrucibleFileInfo crucibleFileInfo) {
        super(review, null);
        this.crucibleFileInfo = crucibleFileInfo;
    }

    @NotNull
    public CrucibleFileInfo getCrucibleFileInfo() {
        return this.crucibleFileInfo;
    }

    public PermId getReviewItemId() {
        return this.reviewItemId;
    }

    @Deprecated
    public void setReviewItemId(PermId reviewItemId) {
        this.reviewItemId = reviewItemId;
    }

    @Deprecated
    public int getFromStartLine() {
        return this.fromStartLine;
    }

    public void setFromStartLine(int startLine) {
        this.fromStartLine = startLine;
    }

    @Deprecated
    public int getFromEndLine() {
        return this.fromEndLine;
    }

    @Deprecated
    public IntRanges getFromLineRanges() {
        return this.fromLineRanges;
    }

    @Override
    protected Comment createReplyBean(Comment reply) {
        return new GeneralComment(reply);
    }

    public void setFromLineRanges(IntRanges fromLineRanges) {
        this.fromLineRanges = fromLineRanges;
        this.setFromLineInfo(true);
        this.setFromStartLine(fromLineRanges.getTotalMin());
        this.setFromEndLine(fromLineRanges.getTotalMax());
    }

    @Deprecated
    public IntRanges getToLineRanges() {
        return this.toLineRanges;
    }

    public Map<String, IntRanges> getLineRanges() {
        return this.lineRanges;
    }

    public void setLineRanges(Map<String, IntRanges> lineRanges) {
        this.lineRanges = lineRanges;
    }

    public void setToLineRanges(IntRanges toLineRanges) {
        this.toLineRanges = toLineRanges;
        this.setToLineInfo(true);
        this.setToStartLine(toLineRanges.getTotalMin());
        this.setToEndLine(toLineRanges.getTotalMax());
    }

    public void setFromEndLine(int endLine) {
        this.fromEndLine = endLine;
    }

    @Deprecated
    public int getToStartLine() {
        return this.toStartLine;
    }

    public void setToStartLine(int startLine) {
        this.toStartLine = startLine;
    }

    @Deprecated
    public int getToEndLine() {
        return this.toEndLine;
    }

    public void setToEndLine(int endLine) {
        this.toEndLine = endLine;
    }

    @Deprecated
    public boolean isFromLineInfo() {
        return this.fromLineInfo;
    }

    public void setFromLineInfo(boolean fromLineInfo) {
        this.fromLineInfo = fromLineInfo;
    }

    @Deprecated
    public boolean isToLineInfo() {
        return this.toLineInfo;
    }

    public void setToLineInfo(boolean toLineInfo) {
        this.toLineInfo = toLineInfo;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.lineRanges != null ? this.lineRanges.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof VersionedComment)) {
            return false;
        }
        VersionedComment other = (VersionedComment)obj;
        if (!MiscUtil.isEqual(this.crucibleFileInfo, other.crucibleFileInfo)) {
            return false;
        }
        if (this.fromEndLine != other.fromEndLine) {
            return false;
        }
        if (this.fromLineInfo != other.fromLineInfo) {
            return false;
        }
        if (!MiscUtil.isEqual(this.fromLineRanges, other.fromLineRanges)) {
            return false;
        }
        if (this.fromStartLine != other.fromStartLine) {
            return false;
        }
        if (!MiscUtil.isEqual(this.lineRanges, other.lineRanges)) {
            return false;
        }
        if (!MiscUtil.isEqual(this.reviewItemId, other.reviewItemId)) {
            return false;
        }
        if (this.toEndLine != other.toEndLine) {
            return false;
        }
        if (this.toLineInfo != other.toLineInfo) {
            return false;
        }
        if (!MiscUtil.isEqual(this.toLineRanges, other.toLineRanges)) {
            return false;
        }
        return this.toStartLine == other.toStartLine;
    }

    public boolean deepEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionedComment)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VersionedComment that = (VersionedComment)o;
        if (this.fromEndLine != that.fromEndLine) {
            return false;
        }
        if (this.fromLineInfo != that.fromLineInfo) {
            return false;
        }
        if (this.fromStartLine != that.fromStartLine) {
            return false;
        }
        if (this.toEndLine != that.toEndLine) {
            return false;
        }
        if (this.toLineInfo != that.toLineInfo) {
            return false;
        }
        if (this.toStartLine != that.toStartLine) {
            return false;
        }
        if (this.lineRangesNotEqual(that.lineRanges)) {
            return false;
        }
        if (this.getReplies() != null ? !this.getReplies().equals(that.getReplies()) : that.getReplies() != null) {
            return false;
        }
        if (!this.reviewItemId.equals(that.reviewItemId)) {
            return false;
        }
        if (this.getReplies().size() != that.getReplies().size()) {
            return false;
        }
        for (Comment vc : this.getReplies()) {
            boolean found = false;
            for (Comment tvc : that.getReplies()) {
                if (vc.getPermId() != tvc.getPermId() || !((VersionedComment)vc).deepEquals(vc)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean lineRangesNotEqual(Map<String, IntRanges> thatLineRanges) {
        if (this.lineRanges == null && thatLineRanges == null) {
            return true;
        }
        if (this.lineRanges == null) {
            return false;
        }
        if (thatLineRanges == null) {
            return false;
        }
        return this.lineRanges.equals(thatLineRanges);
    }
}

