/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.crucible.api.model;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.connector.commons.crucible.CrucibleServerFacade2;
import com.atlassian.theplugin.commons.crucible.api.model.CrucibleUserCache;
import com.atlassian.theplugin.commons.crucible.api.model.User;
import com.atlassian.theplugin.commons.exception.ServerPasswordNotProvidedException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CrucibleUserCacheImpl
implements CrucibleUserCache {
    private final Map<ConnectionCfg, Map<String, User>> serverMap = new HashMap<ConnectionCfg, Map<String, User>>();

    public User getUser(@NotNull CrucibleServerFacade2 facade, ConnectionCfg server, String userId, boolean fetchIfNotExist) {
        Map<String, User> userMap = this.serverMap.get(server);
        if (userMap == null && fetchIfNotExist) {
            List<User> users;
            userMap = new HashMap<String, User>();
            this.serverMap.put(server, userMap);
            try {
                users = facade.getUsers(server);
            }
            catch (RemoteApiException remoteApiException) {
                return null;
            }
            catch (ServerPasswordNotProvidedException serverPasswordNotProvidedException) {
                return null;
            }
            for (User u : users) {
                userMap.put(u.getUsername(), u);
            }
        }
        if (userMap != null) {
            return userMap.get(userId);
        }
        return null;
    }

    public void addUser(ConnectionCfg server, User user) {
        Map<String, User> userMap = this.serverMap.get(server);
        if (userMap == null) {
            userMap = new HashMap<String, User>();
            this.serverMap.put(server, userMap);
        }
        userMap.put(user.getUsername(), user);
    }
}

