/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.crucible.api.model;

import com.atlassian.theplugin.commons.VersionedFileInfo;
import com.atlassian.theplugin.commons.VersionedVirtualFile;
import com.atlassian.theplugin.commons.crucible.api.model.Comment;
import com.atlassian.theplugin.commons.crucible.api.model.CommitType;
import com.atlassian.theplugin.commons.crucible.api.model.FileType;
import com.atlassian.theplugin.commons.crucible.api.model.PermId;
import com.atlassian.theplugin.commons.crucible.api.model.RepositoryType;
import com.atlassian.theplugin.commons.crucible.api.model.VersionedComment;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrucibleFileInfo
implements VersionedFileInfo {
    @Nullable
    private VersionedVirtualFile fileDescriptor;
    @Nullable
    private VersionedVirtualFile oldFileDescriptor;
    private String repositoryName;
    private FileType fileType;
    private String authorName;
    private Date commitDate;
    private CommitType commitType;
    private RepositoryType repositoryType;
    private PermId permId;
    private List<VersionedComment> versionedComments;
    private static final int HASH_NUMBER = 31;

    public CrucibleFileInfo() {
    }

    public CrucibleFileInfo(@Nullable VersionedVirtualFile fileDescriptor, @Nullable VersionedVirtualFile oldFileDescriptor, @NotNull PermId permId) {
        this.fileDescriptor = fileDescriptor;
        this.oldFileDescriptor = oldFileDescriptor;
        this.permId = permId;
        this.versionedComments = new ArrayList<VersionedComment>();
    }

    public List<VersionedComment> getVersionedComments() {
        return this.versionedComments;
    }

    public void setVersionedComments(List<VersionedComment> versionedComments) {
        this.versionedComments = versionedComments;
    }

    public int getNumberOfCommentsDefects() {
        if (this.versionedComments == null) {
            return 0;
        }
        int counter = 0;
        for (VersionedComment comment : this.versionedComments) {
            if (comment.isDefectRaised()) {
                ++counter;
            }
            for (Comment reply : comment.getReplies()) {
                if (!reply.isDefectRaised()) continue;
                ++counter;
            }
        }
        return counter;
    }

    public int getNumberOfCommentsDefects(String userName) {
        if (this.versionedComments == null) {
            return 0;
        }
        int counter = 0;
        for (VersionedComment comment : this.versionedComments) {
            if (comment.isDefectRaised() && comment.getAuthor().getUsername().equals(userName)) {
                ++counter;
            }
            for (Comment reply : comment.getReplies()) {
                if (!reply.isDefectRaised() || !reply.getAuthor().getUsername().equals(userName)) continue;
                ++counter;
            }
        }
        return counter;
    }

    public int getNumberOfCommentsDrafts() {
        if (this.versionedComments == null) {
            return 0;
        }
        int counter = 0;
        for (VersionedComment comment : this.versionedComments) {
            if (comment.isDraft()) {
                ++counter;
            }
            counter += comment.getNumberOfDraftReplies();
        }
        return counter;
    }

    public int getNumberOfCommentsDrafts(String userName) {
        if (this.versionedComments == null) {
            return 0;
        }
        int counter = 0;
        for (VersionedComment comment : this.versionedComments) {
            if (comment.isDraft() && comment.getAuthor().getUsername().equals(userName)) {
                ++counter;
            }
            for (Comment reply : comment.getReplies()) {
                if (!reply.isDraft() || !reply.getAuthor().getUsername().equals(userName)) continue;
                ++counter;
            }
        }
        return counter;
    }

    public int getNumberOfLineComments() {
        if (this.versionedComments == null) {
            return 0;
        }
        int counter = 0;
        for (VersionedComment comment : this.versionedComments) {
            if (!comment.isFromLineInfo() && !comment.isToLineInfo()) continue;
            ++counter;
        }
        return counter;
    }

    public int getNumberOfUnreadComments() {
        if (this.versionedComments == null) {
            return 0;
        }
        int counter = 0;
        for (VersionedComment comment : this.versionedComments) {
            if (comment.isEffectivelyUnread()) {
                ++counter;
            }
            counter += comment.getNumberOfUnreadReplies();
        }
        return counter;
    }

    public int getNumberOfComments(String userName) {
        if (this.versionedComments == null) {
            return 0;
        }
        int counter = 0;
        for (VersionedComment comment : this.versionedComments) {
            if (comment.getAuthor().getUsername().equals(userName)) {
                ++counter;
            }
            for (Comment reply : comment.getReplies()) {
                if (!reply.getAuthor().getUsername().equals(userName)) continue;
                ++counter;
            }
        }
        return counter;
    }

    public int getNumberOfComments() {
        if (this.versionedComments == null) {
            return 0;
        }
        int n = this.versionedComments.size();
        for (VersionedComment c : this.versionedComments) {
            n += c.getNumReplies();
        }
        return n;
    }

    public VersionedVirtualFile getOldFileDescriptor() {
        return this.oldFileDescriptor;
    }

    public PermId getPermId() {
        return this.permId;
    }

    public void setOldFileDescriptor(VersionedVirtualFile oldFileDescriptor) {
        this.oldFileDescriptor = oldFileDescriptor;
    }

    public void setFileDescriptor(VersionedVirtualFile fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
    }

    @Override
    public VersionedVirtualFile getFileDescriptor() {
        return this.fileDescriptor;
    }

    public String toString() {
        VersionedVirtualFile oldFile = this.getOldFileDescriptor();
        VersionedVirtualFile newFile = this.getFileDescriptor();
        if (oldFile != null && oldFile.getUrl().length() > 0 && newFile != null && newFile.getUrl().length() > 0) {
            return String.valueOf(oldFile.getUrl()) + " (mod)";
        }
        if (oldFile != null && oldFile.getUrl().length() > 0) {
            return String.valueOf(oldFile.getUrl()) + " (del)";
        }
        if (newFile != null && newFile.getUrl().length() > 0) {
            return String.valueOf(newFile.getUrl()) + " (new)";
        }
        return "(unknown state)";
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public Date getCommitDate() {
        return this.commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public CommitType getCommitType() {
        return this.commitType;
    }

    public void addComment(VersionedComment comment) {
        this.versionedComments.add(comment);
    }

    public void setCommitType(CommitType commitType) {
        this.commitType = commitType;
    }

    public void setFilePermId(PermId aPermId) {
        this.permId = aPermId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrucibleFileInfo that = (CrucibleFileInfo)o;
        if (this.fileType != that.fileType) {
            return false;
        }
        if (!this.permId.equals(that.permId)) {
            return false;
        }
        if (this.repositoryName != null ? !this.repositoryName.equals(that.repositoryName) : that.repositoryName != null) {
            return false;
        }
        if (this.oldFileDescriptor != null ? !this.oldFileDescriptor.equals(that.oldFileDescriptor) : that.oldFileDescriptor != null) {
            return false;
        }
        return !(this.fileDescriptor != null ? !this.fileDescriptor.equals(that.fileDescriptor) : that.fileDescriptor != null);
    }

    public int hashCode() {
        int result = this.repositoryName != null ? this.repositoryName.hashCode() : 0;
        result = 31 * result + (this.fileDescriptor != null ? this.fileDescriptor.hashCode() : 0);
        result = 31 * result + (this.oldFileDescriptor != null ? this.oldFileDescriptor.hashCode() : 0);
        result = 31 * result + (this.fileType != null ? this.fileType.hashCode() : 0);
        result = 31 * result + this.permId.hashCode();
        return result;
    }

    public RepositoryType getRepositoryType() {
        return this.repositoryType;
    }

    public void setRepositoryType(RepositoryType repositoryType) {
        this.repositoryType = repositoryType;
    }
}

