/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.Activator;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowEditor;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowEditorInput;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowImages;

public class ExportAction
extends WorkbenchPartAction {
    public static final String ID = "Export_action";
    private WebflowEditor editor;

    public ExportAction(WebflowEditor part) {
        super((IWorkbenchPart)part);
        this.editor = part;
        this.setText("Export");
        this.setId(ID);
        this.setToolTipText("Exports the web flow to an image");
        this.setImageDescriptor(WebflowImages.DESC_OBJS_EXPORT_ENABLED);
        this.setDisabledImageDescriptor(WebflowImages.DESC_OBJS_EXPORT_DISABLED);
    }

    public void run() {
        SaveAsDialog dialog = new SaveAsDialog(this.getWorkbenchPart().getSite().getShell());
        IFile editorFile = ((WebflowEditorInput)this.editor.getEditorInput()).getFile();
        String fileName = editorFile.getName();
        fileName = fileName.substring(0, fileName.lastIndexOf("."));
        dialog.setTitle("Export to image");
        dialog.setOriginalFile(editorFile);
        dialog.create();
        dialog.setMessage("Specify a name and location for the image. Either enter .png, .jpg or .bmp extension.");
        dialog.open();
        IPath path = dialog.getResult();
        if (path != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFile(path);
            String ext = file.getFileExtension();
            if (ext == null || ext.length() == 0 || !ext.equalsIgnoreCase("jpg") && !ext.equalsIgnoreCase("jpeg") && !ext.equalsIgnoreCase("bmp") && !ext.equalsIgnoreCase("png")) {
                ErrorDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)"Problem", (String)"Please specify one extension from the following options .png, .jpg or .bmp", (IStatus)Activator.createErrorStatus("error", null));
            } else if (ext.equalsIgnoreCase("PNG") && !SpringCoreUtils.isEclipseSameOrNewer((int)3, (int)3)) {
                ErrorDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)"Problem", (String)"Exporting to PNG format is only supported on Eclipse 3.3 or newer", (IStatus)Activator.createErrorStatus("error", null));
            } else if ("PNG".equalsIgnoreCase(ext)) {
                this.saveImage(file, 5);
            } else if ("JPG".equalsIgnoreCase(ext) || "JPEG".equalsIgnoreCase(ext)) {
                this.saveImage(file, 4);
            } else if ("BMP".equalsIgnoreCase(ext)) {
                this.saveImage(file, 0);
            }
        }
    }

    public void saveImage(final IFile file, final int format) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    if (file.exists()) {
                        file.setContents((InputStream)new ByteArrayInputStream(ExportAction.this.createImage(format)), true, false, monitor);
                    } else {
                        file.create((InputStream)new ByteArrayInputStream(ExportAction.this.createImage(format)), true, monitor);
                    }
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)ExportAction.this.getWorkbenchPart().getSite().getShell(), (String)"Error", (String)"Error during processing of export", (IStatus)e.getStatus());
                }
            }
        };
        try {
            Shell shell = this.getWorkbenchPart().getSite().getWorkbenchWindow().getShell();
            new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public byte[] createImage(int format) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        Display device = this.editor.getGraphViewer().getControl().getDisplay();
        LayerManager lm = (LayerManager)this.editor.getGraphViewer().getEditPartRegistry().get(LayerManager.ID);
        IFigure figure = lm.getLayer((Object)"Printable Layers");
        Rectangle r = figure.getClientArea();
        Image image = null;
        GC gc = null;
        SWTGraphics g = null;
        try {
            image = new Image((Device)device, r.width, r.height);
            gc = new GC((Drawable)image);
            g = new SWTGraphics(gc);
            g.translate(r.x * -1, r.y * -1);
            figure.paint((Graphics)g);
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{image.getImageData()};
            imageLoader.save((OutputStream)result, format);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
            if (gc != null) {
                gc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
        return result.toByteArray();
    }
}

