/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.configurator.operations;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.springsource.ide.eclipse.commons.internal.configurator.operations.AbstractInstallOperation;

public class ChmodOperation
extends AbstractInstallOperation {
    private static final String ATTR_MODE = "mode";
    private static final String ATTR_FILE = "file";
    private final String mode;
    private final String filename;

    public ChmodOperation(IConfigurationElement element) {
        this.mode = element.getAttribute(ATTR_MODE);
        this.filename = element.getAttribute(ATTR_FILE);
    }

    @Override
    public IStatus install(IProgressMonitor monitor) {
        File file;
        block5: {
            file = new File(this.getTargetBase(), this.filename);
            if (file.exists()) {
                String[] command = new String[]{"chmod", this.mode, file.getAbsolutePath()};
                try {
                    Process process = Runtime.getRuntime().exec(command);
                    int result = process.waitFor();
                    if (result != 0) {
                        return new Status(2, "org.springsource.ide.eclipse.commons.configurator", NLS.bind((String)"Execution of chmod command for file ''{0}'' returned unexpected code: {1}", (Object)file.getAbsolutePath(), (Object)result));
                    }
                    break block5;
                }
                catch (IOException e) {
                    return new Status(2, "org.springsource.ide.eclipse.commons.configurator", NLS.bind((String)"Execution of chmod command for file ''{0}'' failed.", (Object)file.getAbsolutePath()), (Throwable)e);
                }
                catch (InterruptedException e) {
                    return new Status(2, "org.springsource.ide.eclipse.commons.configurator", NLS.bind((String)"Execution of chmod command for file ''{0}'' failed.", (Object)file.getAbsolutePath()), (Throwable)e);
                }
            }
            return new Status(2, "org.springsource.ide.eclipse.commons.configurator", NLS.bind((String)"Execution of chmod command for file ''{0}'' failed. File does not exist.", (Object)file.getAbsolutePath()));
        }
        return new Status(0, "org.springsource.ide.eclipse.commons.configurator", NLS.bind((String)"Execution of chmod {0} for file ''{1}'' succeeded.", (Object)this.mode, (Object)file.getAbsolutePath()));
    }

    public String toString() {
        return "ChmodOperation [mode=" + this.mode + ", filename=" + this.filename + "]";
    }
}

