/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.console;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;

public class JavaCompilationErrorHyperlink
extends JavaStackTraceHyperlink {
    public JavaCompilationErrorHyperlink(TextConsole console) {
        super(console);
    }

    protected String getTypeName(String linkText) throws CoreException {
        int start = 0;
        int end = linkText.indexOf(58);
        if (start >= 0 && end > start) {
            String typeName = linkText.substring(start, end);
            typeName = JavaCore.removeJavaLikeExtension((String)typeName);
            String qualifier = linkText.substring(0, start);
            if ((start = qualifier.lastIndexOf(46)) >= 0 && (start = new String((String)qualifier.subSequence(0, start)).lastIndexOf(46)) == -1) {
                start = 0;
            }
            if (start >= 0) {
                qualifier = qualifier.substring(0, start);
            }
            if (qualifier.length() > 0) {
                typeName = String.valueOf(qualifier) + "." + typeName;
            }
            return typeName;
        }
        Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.JavaStackTraceHyperlink_Unable_to_parse_type_name_from_hyperlink__5, null);
        throw new CoreException((IStatus)status);
    }

    protected int getLineNumber(String linkText) throws CoreException {
        int index = linkText.lastIndexOf(91);
        if (index >= 0) {
            String numText = linkText.substring(index + 1);
            if ((index = numText.indexOf(44)) >= 0) {
                numText = numText.substring(0, index);
            }
            try {
                return Integer.parseInt(numText);
            }
            catch (NumberFormatException e) {
                Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.JavaStackTraceHyperlink_Unable_to_parse_line_number_from_hyperlink__6, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.JavaStackTraceHyperlink_Unable_to_parse_line_number_from_hyperlink__6, null);
        throw new CoreException((IStatus)status);
    }

    protected String getLinkText() throws CoreException {
        try {
            IDocument document = this.getConsole().getDocument();
            IRegion region = this.getConsole().getRegion((IHyperlink)this);
            int regionOffset = region.getOffset();
            int lineNumber = document.getLineOfOffset(regionOffset);
            IRegion lineInformation = document.getLineInformation(lineNumber);
            int lineOffset = lineInformation.getOffset();
            String line = document.get(lineOffset, lineInformation.getLength());
            int regionOffsetInLine = regionOffset - lineOffset;
            int linkEnd = line.indexOf(93, regionOffsetInLine);
            int linkStart = line.lastIndexOf(32, regionOffsetInLine) > line.lastIndexOf(47, regionOffsetInLine) ? line.lastIndexOf(32, regionOffsetInLine) : line.lastIndexOf(47, regionOffsetInLine);
            return line.substring(linkStart == -1 ? 0 : linkStart + 1, linkEnd + 1);
        }
        catch (BadLocationException e) {
            Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.JavaStackTraceHyperlink_Unable_to_retrieve_hyperlink_text__8, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }
}

