/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.AnimatedImage;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.AnimatedImageBinding;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.AnimatedImageThread;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.IonicConstants;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.IonicFieldEditorFactory;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.IonicWizardMessages;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.NewIonicWidgetWizardPage;
import org.jboss.tools.jst.web.ui.internal.properties.advanced.LayoutUtil;

public class NewSpinnerWizardPage
extends NewIonicWidgetWizardPage
implements IonicConstants {
    static String PREFIX = "wizards/spinner/";
    static Map<String, AnimatedImage> IMAGES = new HashMap<String, AnimatedImage>();
    boolean isAdjustingIcon = false;

    static {
        int nornalDelay = 80;
        int smallDelay = nornalDelay / 2;
        NewSpinnerWizardPage.addImage("android", 61, nornalDelay);
        NewSpinnerWizardPage.addImage("bubbles", 8, nornalDelay);
        NewSpinnerWizardPage.addImage("circles", 8, nornalDelay);
        NewSpinnerWizardPage.addImage("crescent", 15, smallDelay);
        NewSpinnerWizardPage.addImage("dots", 10, nornalDelay);
        NewSpinnerWizardPage.addImage("ios", 12, nornalDelay);
        NewSpinnerWizardPage.addImage("ios-small", 12, nornalDelay);
        NewSpinnerWizardPage.addImage("lines", 11, nornalDelay);
        NewSpinnerWizardPage.addImage("ripple", 13, nornalDelay);
        NewSpinnerWizardPage.addImage("spiral", 15, smallDelay);
    }

    private static void addImage(String name, int imageCount, int delay) {
        IMAGES.put(name, AnimatedImage.create(String.valueOf(PREFIX) + name + "/" + name, imageCount, delay));
    }

    public NewSpinnerWizardPage() {
        super("newSpinner", IonicWizardMessages.newSpinnerTitle);
        this.setDescription(IonicWizardMessages.newSpinnerWizardDescription);
    }

    protected void createFieldPanel(Composite parent) {
        String[] icons = IonicFieldEditorFactory.spinnerIcons;
        AnimatedImageThread thread = new AnimatedImageThread();
        Group g = parent == null ? null : LayoutUtil.createGroup((Composite)parent, (String)"Icon");
        Composite p = this.createGrid((Composite)g);
        int i = 0;
        while (i < icons.length) {
            Button b;
            IFieldEditor icon = IonicFieldEditorFactory.createSpinnerIconEditor(icons[i], "default");
            this.addEditor(icon, p);
            if (p != null && (b = this.findButton(icon)) != null) {
                AnimatedImage image;
                Composite bp = b.getParent();
                GridData d = (GridData)bp.getLayoutData();
                if (d.horizontalSpan > 2) {
                    d.horizontalSpan = 2;
                    bp.setLayoutData((Object)d);
                }
                if ((image = IMAGES.get(icons[i])) != null) {
                    b.setImage(image.getImage());
                    thread.addBinding(new AnimatedImageBinding(image, b));
                }
            }
            ++i;
        }
        IFieldEditor color = IonicFieldEditorFactory.createSpinnerColorEditor();
        this.addEditor(color, parent);
        thread.start();
    }

    private Composite createGrid(Composite g) {
        if (g != null) {
            Composite c = new Composite(g, 0);
            c.setLayout((Layout)new GridLayout(6, false));
            c.setLayoutData((Object)new GridData(768));
            return c;
        }
        return null;
    }

    private Button findButton(IFieldEditor icon) {
        Object[] objectArray = icon.getEditorControls();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object c = objectArray[n2];
            if (c instanceof Composite) {
                Control[] controlArray = ((Composite)c).getChildren();
                int n3 = controlArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Control c1 = controlArray[n4];
                    if (c1 instanceof Button) {
                        return (Button)c1;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isAdjustingIcon) {
            return;
        }
        String name = evt.getPropertyName();
        if (name.startsWith("icon-")) {
            this.isAdjustingIcon = true;
            String value = evt.getNewValue().toString();
            String[] icons = IonicFieldEditorFactory.spinnerIcons;
            int i = 0;
            while (i < icons.length) {
                String nm = "icon-" + icons[i];
                if (!nm.equals(name)) {
                    this.setEditorValue(nm, value);
                }
                ++i;
            }
            this.isAdjustingIcon = false;
        }
        super.propertyChange(evt);
    }

    protected int getPreferredBrowser() {
        return 65536;
    }
}

