/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.model;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.springframework.ide.eclipse.core.io.ExternalFile;
import org.springframework.ide.eclipse.core.model.AbstractResourceModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.ModelUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractSourceModelElement
extends AbstractResourceModelElement
implements ISourceModelElement {
    private IModelSourceLocation location;

    protected AbstractSourceModelElement(IModelElement parent, String name, IModelSourceLocation location) {
        super(parent, name);
        this.location = location;
    }

    @Override
    public IResourceModelElement getElementSourceElement() {
        IModelElement parent = this.getElementParent();
        while (parent != null) {
            if (!(parent instanceof ISourceModelElement)) {
                return (IResourceModelElement)parent;
            }
            parent = parent.getElementParent();
        }
        return null;
    }

    @Override
    public IResource getElementResource() {
        IResourceModelElement element = this.getElementSourceElement();
        if (element != null) {
            return element.getElementResource();
        }
        return null;
    }

    @Override
    public boolean isElementArchived() {
        IResourceModelElement element = this.getElementSourceElement();
        if (element != null) {
            return element.isElementArchived();
        }
        return false;
    }

    @Override
    public boolean isExternal() {
        return this.getElementResource() instanceof ExternalFile;
    }

    public final void setElementSourceLocation(IModelSourceLocation location) {
        this.location = location;
    }

    @Override
    public final IModelSourceLocation getElementSourceLocation() {
        if (this.location != null) {
            return this.location;
        }
        IModelElement parent = this.getElementParent();
        while (parent != null) {
            if (!(parent instanceof ISourceModelElement)) break;
            IModelSourceLocation location = ((ISourceModelElement)parent).getElementSourceLocation();
            if (location != null) {
                return location;
            }
            parent = parent.getElementParent();
        }
        return null;
    }

    @Override
    public int getElementStartLine() {
        IModelSourceLocation location = this.getElementSourceLocation();
        return location != null ? location.getStartLine() : -1;
    }

    @Override
    public int getElementEndLine() {
        IModelSourceLocation location = this.getElementSourceLocation();
        return location != null ? location.getEndLine() : -1;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IMarker.class) {
            return ModelUtils.createMarker(this);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractSourceModelElement)) {
            return false;
        }
        AbstractSourceModelElement that = (AbstractSourceModelElement)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.location, (Object)that.location)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.location);
        return this.getElementType() * hashCode + super.hashCode();
    }

    public String toString() {
        StringBuffer text = new StringBuffer(this.getElementName());
        text.append(" (");
        text.append(this.getElementStartLine());
        text.append(')');
        return text.toString();
    }

    @Override
    protected String getUniqueElementName() {
        return String.valueOf(this.getElementName()) + ':' + this.getElementStartLine();
    }
}

