/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.internal.project;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidatorDefinition;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidatorDefinitionFactory;
import org.springframework.ide.eclipse.core.project.DefaultProjectContributorState;
import org.springframework.ide.eclipse.core.project.IProjectContributionEventListener;
import org.springframework.ide.eclipse.core.project.IProjectContributor;
import org.springframework.ide.eclipse.core.project.IProjectContributorState;
import org.springframework.ide.eclipse.core.project.IProjectContributorStateAware;
import org.springframework.ide.eclipse.core.project.ProjectBuilderDefinition;
import org.springframework.ide.eclipse.core.project.ProjectBuilderDefinitionFactory;
import org.springframework.ide.eclipse.core.project.ProjectContributionEventListenerFactory;

public class SpringProjectContributionManager
extends IncrementalProjectBuilder {
    private static Object dummyMapObject = new Object();
    private static Map<String, Object> classpathChanged = new ConcurrentHashMap<String, Object>();

    public static void classpathChanged(String projectName) {
        classpathChanged.put(projectName, dummyMapObject);
    }

    protected final IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        Set<IResource> affectedResources;
        final IProject project = this.getProject();
        final IResourceDelta delta = this.getDelta(project);
        final List<ProjectBuilderDefinition> builderDefinitions = ProjectBuilderDefinitionFactory.getProjectBuilderDefinitions();
        final List<ValidatorDefinition> validatorDefinitions = ValidatorDefinitionFactory.getValidatorDefinitions();
        List<IProjectContributionEventListener> listeners = ProjectContributionEventListenerFactory.getProjectContributionEventListeners();
        final IProjectContributorState state = this.prepareState(project, builderDefinitions, validatorDefinitions);
        Object removed = classpathChanged.remove(project.getName());
        final int buildKind = removed != null ? 6 : kind;
        for (final IProjectContributionEventListener listener : listeners) {
            this.execute(new SafeExecutableWithMonitor(){

                @Override
                public void execute(IProgressMonitor subMonitor) throws Exception {
                    listener.start(buildKind, delta, builderDefinitions, validatorDefinitions, state, project, subMonitor);
                }
            }, monitor);
        }
        for (ProjectBuilderDefinition builderDefinition : builderDefinitions) {
            if (!builderDefinition.isEnabled(project)) continue;
            affectedResources = this.getAffectedResources(builderDefinition.getProjectBuilder(), project, buildKind, delta);
            this.runBuilder(builderDefinition, affectedResources, buildKind, monitor, listeners);
        }
        for (ValidatorDefinition validatorDefinition : validatorDefinitions) {
            if (!validatorDefinition.isEnabled(project)) continue;
            affectedResources = this.getAffectedResources(validatorDefinition.getValidator(), project, buildKind, delta);
            this.runValidator(validatorDefinition, affectedResources, buildKind, monitor, listeners);
        }
        for (final IProjectContributionEventListener listener : listeners) {
            this.execute(new SafeExecutableWithMonitor(){

                @Override
                public void execute(IProgressMonitor subMonitor) throws Exception {
                    listener.finish(buildKind, delta, builderDefinitions, validatorDefinitions, state, project, subMonitor);
                }
            }, monitor);
        }
        return null;
    }

    private Set<IResource> getAffectedResources(IProjectContributor contributor, IProject project, int kind, IResourceDelta delta) throws CoreException {
        Set<IResource> affectedResources;
        if (delta == null || kind == 6) {
            ResourceTreeVisitor visitor = new ResourceTreeVisitor(contributor);
            project.accept((IResourceVisitor)visitor);
            affectedResources = visitor.getResources();
        } else {
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(contributor, kind);
            delta.accept((IResourceDeltaVisitor)visitor);
            affectedResources = visitor.getResources();
        }
        return affectedResources;
    }

    private IProjectContributorState prepareState(IProject project, List<ProjectBuilderDefinition> builderDefinitions, List<ValidatorDefinition> validatorDefinitions) {
        DefaultProjectContributorState context = new DefaultProjectContributorState();
        context.hold(project);
        for (ProjectBuilderDefinition builderDefinition : builderDefinitions) {
            if (!builderDefinition.isEnabled(project) || !(builderDefinition.getProjectBuilder() instanceof IProjectContributorStateAware)) continue;
            ((IProjectContributorStateAware)((Object)builderDefinition.getProjectBuilder())).setProjectContributorState(context);
        }
        for (ValidatorDefinition validatorDefinition : validatorDefinitions) {
            if (!validatorDefinition.isEnabled(project) || !(validatorDefinition.getValidator() instanceof IProjectContributorStateAware)) continue;
            ((IProjectContributorStateAware)((Object)validatorDefinition.getValidator())).setProjectContributorState(context);
        }
        return context;
    }

    private void runBuilder(final ProjectBuilderDefinition builderDefinition, final Set<IResource> affectedResources, final int kind, IProgressMonitor monitor, List<IProjectContributionEventListener> listeners) {
        for (final IProjectContributionEventListener listener : listeners) {
            this.execute(new SafeExecutableWithMonitor(){

                @Override
                public void execute(IProgressMonitor subMonitor) throws Exception {
                    listener.startContributor(builderDefinition.getProjectBuilder(), affectedResources, subMonitor);
                    listener.startProjectBuilder(builderDefinition, affectedResources, subMonitor);
                }
            }, monitor);
        }
        this.execute(new SafeExecutableWithMonitor(){

            @Override
            public void execute(IProgressMonitor subMonitor) throws Exception {
                builderDefinition.getProjectBuilder().build(affectedResources, kind, subMonitor);
            }
        }, monitor);
        for (final IProjectContributionEventListener listener : listeners) {
            this.execute(new SafeExecutableWithMonitor(){

                @Override
                public void execute(IProgressMonitor subMonitor) throws Exception {
                    listener.finishContributor(builderDefinition.getProjectBuilder(), affectedResources, subMonitor);
                    listener.finishProjectBuilder(builderDefinition, affectedResources, subMonitor);
                }
            }, monitor);
        }
    }

    private void runValidator(final ValidatorDefinition validatorDefinition, final Set<IResource> affectedResources, final int kind, IProgressMonitor monitor, List<IProjectContributionEventListener> listeners) {
        for (final IProjectContributionEventListener listener : listeners) {
            this.execute(new SafeExecutableWithMonitor(){

                @Override
                public void execute(IProgressMonitor subMonitor) throws Exception {
                    listener.startContributor(validatorDefinition.getValidator(), affectedResources, subMonitor);
                    listener.startValidator(validatorDefinition, affectedResources, subMonitor);
                }
            }, monitor);
        }
        this.execute(new SafeExecutableWithMonitor(){

            @Override
            public void execute(IProgressMonitor subMonitor) throws Exception {
                validatorDefinition.getValidator().validate(affectedResources, kind, subMonitor);
            }
        }, monitor);
        for (final IProjectContributionEventListener listener : listeners) {
            this.execute(new SafeExecutableWithMonitor(){

                @Override
                public void execute(IProgressMonitor subMonitor) throws Exception {
                    listener.finishContributor(validatorDefinition.getValidator(), affectedResources, subMonitor);
                    listener.finishValidator(validatorDefinition, affectedResources, subMonitor);
                }
            }, monitor);
        }
    }

    protected IProgressMonitor createProgressMonitor(IProgressMonitor monitor) {
        return new SubProgressMonitor(monitor, 1);
    }

    protected void execute(final SafeExecutableWithMonitor executable, IProgressMonitor monitor) {
        final IProgressMonitor subMonitor = this.createProgressMonitor(monitor);
        ISafeRunnable code = new ISafeRunnable(){

            public void handleException(Throwable e) {
            }

            public void run() throws Exception {
                executable.execute(subMonitor);
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        subMonitor.done();
    }

    public static class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private IProjectContributor contributor;
        private int kind = -1;
        private Set<IResource> resources;

        public ResourceDeltaVisitor(IProjectContributor builder, int kind) {
            this.contributor = builder;
            this.resources = new LinkedHashSet<IResource>();
            this.kind = kind;
        }

        public Set<IResource> getResources() {
            return this.resources;
        }

        public boolean visit(IResourceDelta aDelta) throws CoreException {
            boolean visitChildren = false;
            IResource resource = aDelta.getResource();
            if (resource instanceof IProject) {
                visitChildren = SpringCoreUtils.isSpringProject(resource);
                if (visitChildren) {
                    this.resources.addAll(this.contributor.getAffectedResources(resource, this.kind, aDelta.getKind()));
                }
            } else if (resource instanceof IFolder) {
                this.resources.addAll(this.contributor.getAffectedResources(resource, this.kind, aDelta.getKind()));
                visitChildren = true;
            } else if (resource instanceof IFile) {
                switch (aDelta.getKind()) {
                    case 1: 
                    case 4: {
                        this.resources.addAll(this.contributor.getAffectedResources(resource, this.kind, aDelta.getKind()));
                        visitChildren = true;
                        break;
                    }
                    case 2: {
                        this.resources.addAll(this.contributor.getAffectedResources(resource, this.kind, aDelta.getKind()));
                    }
                }
            }
            return visitChildren;
        }
    }

    public static class ResourceTreeVisitor
    implements IResourceVisitor {
        private IProjectContributor contributor;
        private Set<IResource> resources;

        public ResourceTreeVisitor(IProjectContributor builder) {
            this.contributor = builder;
            this.resources = new LinkedHashSet<IResource>();
        }

        public Set<IResource> getResources() {
            return this.resources;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                this.resources.addAll(this.contributor.getAffectedResources(resource, 6, 4));
            } else if (resource instanceof IProject) {
                this.resources.addAll(this.contributor.getAffectedResources(resource, 6, 4));
            }
            return true;
        }
    }

    protected static interface SafeExecutableWithMonitor {
        public void execute(IProgressMonitor var1) throws Exception;
    }
}

